#ifndef _TIMER_H
#define _TIMER_H

#include <string>
#include <map>
#include <iostream>
#include <fstream>
#include "base.h"

// взял из аркадии
#if defined (_win32_) || defined (_win64_)
	int gettimeofday(struct timeval *tp, void*);
#else
	#include <sys/time.h>
#endif


ui64 ToMicroSeconds(const struct timeval* tv);
ui64 MicroSeconds();

class Timer
{
private:
    #ifdef _win32_
    // начало
    time_t _start;
    // конец
    time_t _stop;
    #else
    // начало
    ui64 _start;
    // конец
    ui64 _stop;
    #endif
    // присвоенное имя
    const char * _name;

public:
    // конструктор по умолчанию
    Timer() : _start(0), _stop(0), _name(""){}
    // конструктор
    Timer(const char* name) : _start(0), _stop(0), _name(name){}
    // деструктор
    ~Timer(){}

public:
    #ifdef _win32_
    // начинаем отсчет
    void start();
    // останавливаем
    void stop();
    #else
    // начинаем отсчет
    void start() { _start = MicroSeconds(); }
    // останавливаем
    void stop()  { _stop  = MicroSeconds(); }
    #endif
    // получаем время
    ui64 getTime() { return _stop - _start; }
    // получаем название
    const char * getName() { return _name; }
    // инициализировать перевод месяцев
    //TODO: переместить в конструктор
    static void initMonths(std::map<std::string, std::string> & months)
    {
        months.erase(months.begin(), months.end());
        months[std::string("Jan")] = std::string("01");
        months[std::string("Feb")] = std::string("02");
        months[std::string("Mar")] = std::string("03");
        months[std::string("Apr")] = std::string("04");
        months[std::string("May")] = std::string("05");
        months[std::string("Jun")] = std::string("06");
        months[std::string("Jul")] = std::string("07");
        months[std::string("Aug")] = std::string("08");
        months[std::string("Sep")] = std::string("09");
        months[std::string("Oct")] = std::string("10");
        months[std::string("Nov")] = std::string("11");
        months[std::string("Dec")] = std::string("12");
    }
    // получить дату и время: 2009-02-17 16:02:27
    static std::string getDateTime();
};

// добавляем сообщение в log файл
template<typename T>
inline void message(const std::string& filePath, const char * head, const T body)
{
    if (filePath.empty()) {
        std::cerr << Timer::getDateTime().c_str() << " " << head << body << std::endl;
        return;
    }
    std::fstream flog(filePath.c_str(), std::ios::out | std::ios::app);
    flog << Timer::getDateTime().c_str() << " " << head << body << std::endl;
}
// добавляем сообщение в log файл
inline void messageWOTime(const std::string& filePath, const char * head, const int bodyInt)
{
    if (filePath.empty()) {
        std::cerr << head << bodyInt << std::endl;
        return;
    }
    std::fstream flog(filePath.c_str(), std::ios::out | std::ios::app);
    flog << head << bodyInt << std::endl;
}

#endif

