#! /bin/sh

echo 'Все негеокодированные и неинтерполированные станции, а также совпадающие станции и станции, поставленные вручную:'
echo

cat badStationLocation.txt  | egrep 'empty_loc|strange_loc|same_loc|set_correction'

echo
echo 'Интерполированные станции:'
echo

cat badStationLocation.txt  | grep 'interpolated'

echo
echo 'Станции, которые не удалось поставить на рельсы:'
echo

cat badStationLocation.txt  | grep 'station_without_curve'

echo
echo 'Станции, расположенные далее 100 метров от рельсов:'
echo

cat badStationLocation.txt | grep 'station_move_to_curve' | grep "dist=[0-9]\.[1-9]*.curve"

echo
echo 'Самые плохогеокодированные вспомогательные маршруты:'
echo

cat badStationLocation.txt | grep 'wrong auxilary path' | sed 's/from.*//' | sort | uniq -c | sort -n -r | head

echo
echo 'Все плохогеокодированные вспомогательные маршруты:'
echo

cat badStationLocation.txt | grep 'wrong auxilary path'

echo 
echo 'Станции, между которыми не получилось провести кривую по рельсам:'
echo

cat badStationLocation.txt  | grep 'jump'
cat badStationLocation.txt  | grep 'no path from'

