#coding:utf-8
try:
    from osgeo import gdal
    from osgeo import ogr
    from osgeo import osr
    from osgeo import gdalconst
except ImportError:
    #import gdal
    import ogr
    import osr
    import gdalconst
import os, os.path, sys


OGRwkbGeometryType = {
  0 : 'wkbUnknown', 1 : 'wkbPoint', 2 : 'wkbLineString',  3 : 'wkbPolygon',
  4 : 'wkbMultiPoint', 5 : 'wkbMultiLineString', 6 : 'wkbMultiPolygon', 7 : 'wkbGeometryCollection',
  100 : 'wkbNone', 101 : 'wkbLinearRing', 0x80000001 : 'wkbPoint25D', 0x80000002 : 'wkbLineString25D',
  0x80000003 : 'wkbPolygon25D', 0x80000004 : 'wkbMultiPoint25D', 0x80000005 : 'wkbMultiLineString25D',
  0x80000006 : 'wkbMultiPolygon25D', 0x80000007 : 'wkbGeometryCollection25D'
}

OGRFieldType = {
  0 : 'OFTInteger', 1 : 'OFTIntegerList', 2 : 'OFTReal', 3: 'OFTRealList',
  4 : 'OFTString', 5 : 'OFTStringList', 6 : 'OFTWideString', 7 : 'OFTWideStringList',
  8 : 'OFTBinary', 9 : 'OFTDate', 10 : 'OFTTime', 11 : 'OFTDateTime'
}

class tabObj:
    outputData = None
    outputLayer = None
    fieldList = {}
    tabSpatRef = None
    def __init__(self, outPath = None):
        if outPath is None:
            sys.exit( 1 )
        else:
            driverName = "MapInfo File"
            drv = ogr.GetDriverByName(driverName)
            if drv is None:
                print "%s driver not available." % driverName
                sys.exit(1)
            self.outputData = drv.CreateDataSource(outPath)
            if self.outputData is None:
                print "Creation of output file failed.", outPath
                sys.exit(1)
            layerName = os.path.basename(outPath).strip(".tab")
            spatRef = osr.SpatialReference()
            spatRef.ImportFromEPSG(54004)
            self.tabSpatRef = spatRef
            self.outputLayer = self.outputData.CreateLayer(layerName, spatRef, ogr.wkbUnknown)
            if self.outputLayer is None:
                print "Layer creation failed."
                sys.exit( 1 )

    def set_layer_spec(self):
        if self.fieldList is None:
                print "Field list is empty"
                sys.exit(1)
        for fName, fSpec in self.fieldList.items():
            fieldDefn = ogr.FieldDefn( fName, fSpec[0])
            fieldDefn.SetWidth(fSpec[1])
            if self.outputLayer.CreateField(fieldDefn) != 0:
                print "Can't create field %s" % fieldDefn.GetNameRef()
                sys.exit( 1 )

    def InitLayerFromFile(self, origPath, srcFilePath):
	print srcFilePath
	resList = []
        ogrDS = ogr.Open(srcFilePath, False)
        if ogrDS is None:
            print "I cann't open %s"%fpath
        else:
            srcLayer = ogrDS.GetLayer(0) #SpatRef = srcLayer.GetSpatialRef()
            srcLayerDefn = srcLayer.GetLayerDefn()
#            print "!src!", srcFilePath
            srcFeat = srcLayer.GetNextFeature()
            if srcFeat is not None:
                srcFeatRef = srcFeat.GetDefnRef()
                for i in range(srcFeatRef.GetFieldCount()):
                    fieldDefn = srcFeatRef.GetFieldDefn(i)
                    name = fieldDefn.GetNameRef().lower()
                    if not self.fieldList.has_key(name):
                        print "+", name
                        self.fieldList[name] = (fieldDefn.GetType(), fieldDefn.GetWidth())
            ogrDS.Destroy()

    def AddLayerFromFile(self, origPath, srcFilePath):
	print srcFilePath
	resList = []
        ogrDS = ogr.Open(srcFilePath, False)
        if ogrDS is None:
            print "I cann't open %s"%fpath
        else:
            srcLayer = ogrDS.GetLayer(0) #SpatRef = srcLayer.GetSpatialRef()
            srcLayerDefn = srcLayer.GetLayerDefn()
#            print "!src!", srcFilePath
            srcFeat = srcLayer.GetNextFeature()
            if srcFeat is not None:
                srcFeatRef = srcFeat.GetDefnRef()
                while srcFeat is not None:
                    outFeat = ogr.Feature(self.outputLayer.GetLayerDefn())
                    srcFeatRef = srcFeat.GetDefnRef()
                    for i in range(srcFeatRef.GetFieldCount()):
                        mapId = srcFilePath[:]
                        mapId = mapId[:mapId.find('/_data/mapinfo/design')]
                        mapId = mapId[mapId.find('/world/') + len('/world/'):]
                        outFeat.SetField('map', mapId)
                        fieldDefn = srcFeatRef.GetFieldDefn(i)
                        fName = fieldDefn.GetNameRef().lower()
                        fType = fieldDefn.GetType()
                        if (fName in self.fieldList) and (fType == self.fieldList.get(fName)[0]):
                            outFeat.SetField(fName, srcFeat.GetFieldAsString(i))
#			    print fName, srcFeat.GetFieldAsString(i)
                    srcGeom = srcFeat.GetGeometryRef()
                    if isinstance(srcGeom, ogr.Geometry):
#                        print "Geom"
                        if srcGeom.IsValid():
                            srcGeom.AssignSpatialReference(srcLayer.GetSpatialRef())
                            srcGeom.TransformTo(self.tabSpatRef )
                            outFeat.SetGeometry(srcGeom)
#                            print "Geom", srcGeom
                            if self.outputLayer.CreateFeature(outFeat) != 0:
                                print "Failed to create feature in tabfile.\n"
                                sys.exit( 1 )
                    outFeat.Destroy()
                    srcFeat = srcLayer.GetNextFeature()
            ogrDS.Destroy()

    def Destroy(self):
        if self.outputData is not None:
            self.outputData.Destroy()

def EndsWith(fileName, endList):
    if endList[0] == "*":
        return True
    for e in endList:
        if fileName.endswith(e):
            return True
    return False        

def FindTab(origPath, p, f, tab, initLayers):
    print origPath, p, f
    if os.path.isdir(p):
        for dir_element in os.listdir(p):
            subpath = os.path.join(p, dir_element)
            subdir = os.path.split(subpath)[0]
            if os.path.isdir(subpath) and not dir_element.startswith('.'):
                FindTab(origPath, subpath, f, tab, initLayers)
            else:
                if os.path.isfile(subpath) and dir_element.lower().endswith('.tab') and EndsWith(dir_element.lower(), f):
					if initLayers:
						tab.InitLayerFromFile(origPath, subpath)
					else:
						tab.AddLayerFromFile(origPath, subpath)
#                if f != "*":
#                   print subpath, dir_element, f, os.path.isfile(subpath), dir_element.lower().endswith(f.lower()), subdir.endswith('_data\\mapinfo\\design'), subdir.lower().find('old')
#                    if (os.path.isfile(subpath) and 
#			            dir_element.lower().endswith(f.lower()) and
#                        subdir.endswith('_data/mapinfo/design') and
#                        subdir.lower().find('old') == -1):
#                        print "go"
#                        tab.AddLayerFromFile(origPath, subpath)
#                else:
#                   print subpath, dir_element, "os.path.isfile(subpath)=", os.path.isfile(subpath), "dir_element.lower().endswith('.tab')=", dir_element.lower().endswith('.tab')
#                    if os.path.isfile(subpath) and dir_element.lower().endswith('.tab'):
#                        tab.AddLayerFromFile(origPath, subpath)

    else :
        print "%s isn't a directory"%p

def ListToDir(list):
    d = dict([(list[i], list[i+1]) for i in range(0,len(list)-len(list)%2, 2)])
    return d

if len(sys.argv) > 1:
    keyList = ListToDir(sys.argv[1::])
#    if '-sd' and '-f' and '-sf' in keyList.keys():
#	print 'sd'
#        newTab = tabObj(keyList['-sf'])
#        FindTab(keyList['-sd'], keyList['-sd'], keyList['-f'], newTab)
#        newTab.Destroy()
    if '-dirlist' and '-f' and '-sf' in keyList.keys():
        print 'dirlist'
        newTab = tabObj(keyList['-sf'])
        f = keyList['-f']
        flist = f.split(',')
        print f, flist
        dirlist = open(keyList['-dirlist'], "r")
        for line in dirlist:
            d = line.strip()
            d += "/"
            FindTab(d, d, flist, newTab, True)
        newTab.fieldList['map'] = (4, 200)
        newTab.set_layer_spec()
        dirlist.close()
        
        dirlist = open(keyList['-dirlist'], "r")
        for line in dirlist:
            d = line.strip()
            d += "/"
            FindTab(d, d, flist, newTab, False)
        newTab.Destroy()



