#include "thegraph.h"
#include "timer.h"
#include "curve.h"

using namespace Pathfinder;

int main(int argc, char * argv[])
{
    if (argc < 3)
    {
        return 1;
    };

    std::string place(argv[1]);
    std::string mif_path(argv[2]);
    std::string xml_path("xml");
    if (argc >= 4)
        xml_path = argv[3];
    xml_path += "/out.xml";

    const std::string tableFile = place + "/thegraph";
    const std::string townFile = place + "/townOrig-name.map";
    const std::string stationFile = place + "/station-table.map";
    const std::string stationCorrectionFile = "station-geo-correction.txt";
    const std::string station2expressCode = "/stationOrig-expressCode.map";

    Timer timer;
    timer.start();

    TheGraph theGraph;
    const int towns = theGraph.SG.st.loadTowns(townFile.c_str());
    const int stations = theGraph.SG.st.loadStations(stationFile.c_str());
    const std::string stationGeoFile = place + "/stationOrig-geo.map";
    const int geoRes = theGraph.SG.st.loadGeo(stationGeoFile.c_str());

    std::ofstream log("badStationLocation.txt");
    std::ofstream log1("1badStationLocation.txt");

    std::ofstream fout1("straightRoads.mp");
    fout1.precision(12);
    fout1 << "[IMG ID]" << std::endl;
    fout1 << "CodePage=1251" << std::endl;
    fout1 << "LblCoding=9" << std::endl;
    fout1 << "ID=" << std::endl;
    fout1 << "Name=" << std::endl;
    fout1 << "Preprocess=F" << std::endl;
    fout1 << "TreSize=511" << std::endl;
    fout1 << "TreMargin=0.00000" << std::endl;
    fout1 << "RgnLimit=127" << std::endl;
    fout1 << "POIIndex=Y" << std::endl;
    fout1 << "Levels=2" << std::endl;
    fout1 << "Level0=24" << std::endl;
    fout1 << "Level1=23" << std::endl;
    fout1 << "Zoom0=0" << std::endl;
    fout1 << "Zoom1=1" << std::endl;
    fout1 << "[END-IMG ID]" << std::endl;
    fout1 << std::endl;

    Geom::CurveMap curveMap;
    std::ifstream fin_for_delete((mif_path + "/for_delete.txt").c_str());
    std::ifstream mid((mif_path + "/rw_full.mid").c_str());
    std::ifstream mif((mif_path + "/rw_full.mif").c_str());
    curveMap.loadMIDMIF(mid, mif, fin_for_delete);
    std::sort(curveMap.allCoefs.begin(), curveMap.allCoefs.end());

    const int graphRes = theGraph.SG.load("1badStationLocation.txt", tableFile.c_str(), (Transport::Type)(Transport::TRAIN|Transport::LOCAL_TRAIN), true/*forRailway*/);
    const int graphResXML = theGraph.SG.loadXML("1badStationLocation.txt", xml_path.c_str(), (place+station2expressCode).c_str());
    theGraph.SG.createAllStructures("1badStationLocation.txt");

    std::cout << "curves in map " << curveMap.curves.size() << std::endl;
    theGraph.SG.st.initStationToCostations();
    timer.stop();

    fprintf(stdout, "graph (%d): %ld, towns=%d, stations=%d\n", graphRes, static_cast<long>(timer.getTime()), towns, stations);
    fprintf(stdout, "graph size = %d \n", static_cast<int>(theGraph.SG._graph.size()));

    int r1 = 0;//theGraph.SG.filterBadStationLocation(log, (Transport::Type)(Transport::TRAIN|Transport::LOCAL_TRAIN));
    int r2 = 0;//theGraph.SG.filterBadStationLocation(log, (Transport::Type)(Transport::TRAIN|Transport::LOCAL_TRAIN));

//	theGraph.SG.st.saveStationsAsPolish(fout1, (Transport::Type)(Transport::TRAIN|Transport::LOCAL_TRAIN), "3328");

    int r3 = curveMap.setStationsOnCurves(fout1, log, theGraph.SG.st.stationInfos, (Transport::Type)(Transport::TRAIN|Transport::LOCAL_TRAIN), 0.001, 1.0, true, false/*do_log*/);

    int r4 = theGraph.SG.interpolateEmptyStationLocation(log, (Transport::Type)(Transport::TRAIN|Transport::LOCAL_TRAIN));

    int r5 = 0;//curveMap.setStationsOnCurves(fout1, log, theGraph.SG.st.stationInfos, (Transport::Type)(Transport::TRAIN|Transport::LOCAL_TRAIN), 0.01, 10, true);
    int r55 = 0;//curveMap.setStationsOnCurves(fout1, log, theGraph.SG.st.stationInfos, (Transport::Type)(Transport::TRAIN|Transport::LOCAL_TRAIN), 0.04, 5, true);
    int r555 = curveMap.setStationsOnCurves(fout1, log, theGraph.SG.st.stationInfos, (Transport::Type)(Transport::TRAIN|Transport::LOCAL_TRAIN), 0.06, 2, true, true/*do_log*/);

    std::ifstream finSC(stationCorrectionFile.c_str());
    int r50 = curveMap.setStationsOnCurves_correction(finSC, fout1, log, theGraph.SG.st);
    int r51 = curveMap.createPoint2StationMap(theGraph.SG.st.stationInfos, (Transport::Type)(Transport::TRAIN|Transport::LOCAL_TRAIN));

    curveMap.createCurveNeigsMap(0.002);
//	log << "glued: " << resGlue << std::endl;
    curveMap.savePolish(fout1, "3328");

    //theGraph.SG.fillShortestPaths(fout1, (Transport::Type)(Transport::TRAIN|Transport::LOCAL_TRAIN));
    //theGraph.SG.fillNearestNeigs((Transport::Type)(Transport::TRAIN|Transport::LOCAL_TRAIN));

    int r6 = theGraph.SG.st.checkSameLocation(log, Transport::LOCAL_TRAIN);

    log << "geocoded_beg=" << geoRes << std::endl;
    log << "filtered1=" << r1 << std::endl;
    log << "filtered2=" << r2 << std::endl;
    log << "set1=" << r3 << std::endl;
    log << "interpolated=" << r4 << std::endl;
    log << "set2=" << r5 << std::endl;
    log << "set22=" << r55 << std::endl;
    log << "set222=" << r555 << std::endl;
    log << "set_corr=" << r50 << std::endl;
    log << "same_loc="<< r6 << std::endl;

    theGraph.SG.st.saveStationsAsPolish(fout1, (Transport::Type)(Transport::TRAIN|Transport::LOCAL_TRAIN), "3328");

    theGraph.SG.fillNearestNeigs2((Transport::Type)(Transport::TRAIN|Transport::LOCAL_TRAIN));

    int maxLayer = curveMap.markBestPoints();
    std::cout << "Max Layer = " << maxLayer << std::endl;

    theGraph.SG.fillCurves(log, curveMap, 0.00002, (Transport::Type)(Transport::TRAIN|Transport::LOCAL_TRAIN));
//	theGraph.SG.saveCurveRoadsAsPolish(fout1, (Transport::Type)(Transport::TRAIN|Transport::LOCAL_TRAIN), "0x06", false);

    int r7 = theGraph.SG.saveThreadsAsPolish(log, fout1, (Transport::Type)(Transport::TRAIN|Transport::LOCAL_TRAIN), "0x06", 0, 10000000, 20, 6);
    //int r7 = theGraph.SG.saveThreadsAsPolish(fout1, (Transport::Type)(Transport::TRAIN|Transport::LOCAL_TRAIN), "0x06", 1, 10000000, 10);
//	theGraph.SG.saveThreadsAsPolish(fout1, Transport::LOCAL_TRAIN, "0x06");
    int r8 = theGraph.SG.calcLongestPointPath(log, Transport::LOCAL_TRAIN);
    log << "thread_saved = " << r7 << std::endl;
    log << "maxPathNumber = " << r8 << std::endl;

//	theGraph.SG.saveRoadsAsPolishFar(fout1, Transport::TRAIN, "0x06");
//	theGraph.SG.saveRoadsAsPolishFar(fout1, Transport::LOCAL_TRAIN, "0x0a");
    //theGraph.SG.saveRoadsAsPolishNear(fout1, Transport::TRAIN, "0x06", false);
    //theGraph.SG.saveRoadsAsPolishNear(fout1, Transport::LOCAL_TRAIN, "0x0a", false);

    std::ofstream edgesOut("edge2curve.txt");
    edgesOut.precision(10);
    theGraph.SG.saveEdge2Curve(edgesOut, (Transport::Type)(Transport::TRAIN|Transport::LOCAL_TRAIN));

    return 0;
}

