import sys

template = '/search?from_type={from_type}&from_id={from_id}&to_type={to_type}&to_id={to_id}&date={date}+00%3A00%3A00{ttype}&boarding=1440&min_delay=120&max_delay=1380'
default_ttype = '&ttype=1&ttype=2&ttype=3&ttype=6&ttype=11'
suffix_ttype = '&ttype='

def station_type(station):
    if station[0]=='c':
        return 'Settlement'
    return 'Station'

def station_number(station):
    return station[1:]

def ttype_to_number(ttype):
    if ttype=='train':
        return 1
    if ttype=='plane':
        return 2
    if ttype=='bus':
        return 3
    if ttype=='suburban':
        return 6
    if ttype=='water':
        return 11


if __name__ == '__main__':
    for line in sys.stdin:
        words = line.strip().split()
        date = words[2]
        ttype = default_ttype
        if len(words) == 4:
            date = words[3]
            ttype = suffix_ttype+str(ttype_to_number(words[2]))

        res = template.format(from_id=station_number(words[0]), from_type=station_type(words[0]), 
                              to_id=station_number(words[1]), to_type=station_type(words[1]), date=date, ttype=ttype)
        print(res)

