#include "clientsocket.h"
#include "socketexception.h"


// structor
ClientSocket::ClientSocket(const std::string & host, const int port)
{
    if (Socket::create() == false)
        throw SocketException("could not create client socket");

    if (Socket::connect(host, port) == false)
        throw SocketException("could not bind to port");
}


// send
const ClientSocket &
ClientSocket::operator << (const std::string & str) const
{
    if (Socket::send(str) == false )
        throw SocketException ("could not write to socket");
    return *this;
}


// receive
const ClientSocket &
ClientSocket::operator >> (std::string & str) const
{
    if (Socket::recv(str) == 0)
        throw SocketException("could not read from socket");
    return *this;
}


// receive
int
ClientSocket::recv(std::string & str) const
{
    const int res = Socket::recv(str);
    if (res == 0)
        throw SocketException("could not read from socket");
    return res;
}


// receive
int
ClientSocket::recv(std::string & str, const int length) const
{
    const int res = Socket::recv(str, length);
    if (res == 0)
        throw SocketException("could not read from socket");
    return res;
}

