#include <stdio.h>

#include "serversocket.h"
#include "socketexception.h"
#include <fstream>


// structors
ServerSocket::ServerSocket(const int port, const std::string & str)
{
    if (Socket::create() == false)
    {
	std::fstream fout(str.c_str(), std::ios::app | std::ios::out);
	fout << "could not create server socket\n";
	fout.close();
        throw SocketException("could not create server socket");
    }

    if (Socket::bind(port) == false)
    {
	std::fstream fout(str.c_str(), std::ios::app | std::ios::out);
	fout << "could not bind to port\n";
	fout.close();
        throw SocketException("could not bind to port");
    }
    
    if (Socket::listen() == false)
    {
	std::fstream fout(str.c_str(), std::ios::app | std::ios::out);
	fout << "could not listen to socket\n";
	fout.close();
        throw SocketException("could not listen to socket");
    }
}


// accept
void
ServerSocket::accept(ServerSocket & sock)
{
    if (Socket::accept(sock) == false)
	{
		char temp[1000];
        sprintf(temp, "could not accept socket. new_socket.sock = %d\n", sock.sock);
		throw SocketException(temp);
	}
}


// send
const ServerSocket &
ServerSocket::operator << (const std::string & str) const
{
    if (Socket::send(str) == false)
        ;//throw SocketException("could not write to socket");
    return *this;
}


// receive
const ServerSocket &
ServerSocket::operator >> (std::string & str) const
{
    if (Socket::recv(str) == 0)
        ;//throw SocketException("could not read from socket");
    return *this;
}


// receive
int
ServerSocket::recv(std::string & str) const
{
    const int res = Socket::recv(str);
    if (res == 0)
        ;//throw SocketException("could not read from socket");
    return res;
}


// receive
int
ServerSocket::recv(std::string & str, const int length) const
{
    const int res = Socket::recv(str, length);
    if (res == 0)
        ;//throw SocketException("could not read from socket");
    return res;
}
