#include <stdio.h>

#include "clientsocket.h"
#include "socketexception.h"

#include "../webutil.h"
using namespace Pathfinder;

int main(int argc, char **argv)
{
    try
    {
        ClientSocket client_socket("localhost", 8089);
        fprintf(stdout, "client is ready...\n");

        size_t count(0);
        std::string request, response;
        
        while (true)
        {
            ++count;
            const bool ok = true;
            const bool close = (count > 3);
            request = WebUtil::generateHTTPRequest(ok, close);

            client_socket << request;
            fprintf(stdout, "client.out=%s\n", request.c_str());

            if (close)
                break;

            client_socket.recv(response);
            fprintf(stdout, "client.in =%s\n\n", response.c_str());
        }
    }
    catch (SocketException & e)
    {
        fprintf(stderr, "client.exc=%s\n", e.description().c_str());
    }
    
    fprintf(stdout, "finish\n");

    return 0;
}
