#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>
#include <iostream>

#include "socket.h"
#include "string.h"


Socket::Socket()
 :sock(-1)
{
    memset(&addr, 0, sizeof(addr));
}


Socket::~Socket()
{
    if (is_valid())
        ::close(sock);
}


// server initialization
bool
Socket::create()
{
    sock = socket(AF_INET, SOCK_STREAM, 0);

    if (is_valid() == false)
        return false;

    // TIME_WAIT - argh
    int on = 1;
    if (setsockopt(sock, SOL_SOCKET, SO_REUSEADDR, (const char*)&on, sizeof(on)) == -1)
        return false;
    return true;
}
//
bool
Socket::bind(const int port)
{
    if (is_valid() == false)
        return false;

    addr.sin_family = AF_INET;
    addr.sin_addr.s_addr = INADDR_ANY;
    addr.sin_port = htons(port);

    int bind_return = ::bind(sock, (struct sockaddr *)&addr, sizeof(addr));

    if (bind_return == -1)
        return false;

    return true;
}
//
bool
Socket::listen() const
{
    if (is_valid() == false)
        return false;

    const int listen_return = ::listen(sock, MAXCONNECTIONS);

    if (listen_return == -1)
        return false;

    return true;
}
//
bool
Socket::accept(Socket & new_socket)const
{
    int addr_length = sizeof(addr);
    new_socket.sock = ::accept(sock, (sockaddr *)&addr, (socklen_t *)&addr_length);

    if (new_socket.sock < 0)
        return false;
    else
        return true;
}


// client initialization
bool
Socket::connect(const std::string & host, const int port)
{
    if (is_valid() == false)
        return false;

    addr.sin_family = AF_INET;
    addr.sin_port = htons(port);

    //const int status = inet_pton(AF_INET, host.c_str(), &addr.sin_addr);
    inet_pton(AF_INET, host.c_str(), &addr.sin_addr);

    if (errno == EAFNOSUPPORT)
        return false;

    const int connect_status = ::connect(sock, (sockaddr *)&addr, sizeof(addr));

    if (connect_status == 0)
        return true;
    else
        return false;
}


// data transimission: send
bool
Socket::send(const std::string & str)const
{
    const int status = ::send(sock, str.c_str(), str.size(), MSG_NOSIGNAL);
    if (status == -1)
        return false;
    else
        return true;
}


// receive
int
Socket::recv(std::string & str) const
{
    char buf [MAXRECV + 1];
    str = "";
    memset(buf, 0, MAXRECV + 1);

    const int status = ::recv(sock, buf, MAXRECV, 0);

    if (status == -1)
    {
        fprintf(stderr, "status == -1\terrno == %d in Socket::recv\n", errno);
        return 0;
    }
    else if (status == 0)
    {
        return 0;
    }
    else
    {
        str = buf;
        return status;
    }
}


// receive
/*
int
Socket::recv(std::string & str, const int length) const
{
    if (length <= 0)
        return 0;

    char * buffer = new char [length + 1];
    memset(buffer, 0, length + 1);
    const int status = ::recv(sock, buffer, length, 0);

    int result = status;
    switch (status)
    {
    case(-1):
        {
            fprintf(stderr, "status == -1\terrno == %d in Socket::recv\n", errno);
            result = 0;
            break;
        }
    case(0):
        {
            break;
        }
    default:
        {
            str = buffer;
        }
    }
    
    delete [] buffer;
    return status;
}
*/


// receive
int
Socket::recv(std::string & str, const int length) const
{
    if (length <= 0)
        return 0;

    str.reserve(length);
    char buffer [1024];
    int rest = length;

    while (rest > 0)
    {
        const int status = ::recv(sock, buffer, length, 0);
        switch (status)
        {
        case(-1):
            {
                fprintf(stderr, "status == -1\terrno == %d in Socket::recv\n", errno);
                return 0;
            }
        case(0):
            {
                break;
            }
        default:
            {
                str.append(buffer, status);
                rest -= status;
            }
        }
    }

    return str.length();
}


void Socket::set_non_blocking(const bool non_block)
{
    int opts = fcntl(sock, F_GETFL);
    if (opts < 0)
        return;

    if (non_block)
        opts = (opts | O_NONBLOCK);
    else
        opts = (opts & ~O_NONBLOCK);

    fcntl(sock, F_SETFL, opts);
}
