#ifndef socket_h
#define socket_h

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <unistd.h>
#include <string>
#include <arpa/inet.h>


const int MAXHOSTNAME = 200;
const int MAXCONNECTIONS = 10;
const int MAXRECV = 500;

class Socket
{
private:
    // structure for handling internet addresses
    sockaddr_in addr;

public:
    // socket
    int sock;
    
	Socket();
    virtual ~Socket();

public:
    // server initialization
    bool create();
    bool bind(const int port);
    bool listen() const;
    bool accept(Socket & socket) const;

    // client initialization
    bool connect(const std::string & host, const int port);

    // data transimission: send
    bool send(const std::string & str) const;
    // data transimission: receive
    int recv(std::string & str) const;
    // data transimission: receive
    int recv(std::string & str, const int length) const;

    //
    void set_non_blocking(const bool non_block);
    //
    bool is_valid() const { return sock != -1; }
};

#if defined __APPLE__
# define MSG_NOSIGNAL SO_NOSIGPIPE
#endif

#endif
