#include "webutil.h"

namespace Pathfinder
{
    // словарь
    const std::string WebUtil::_sep = "\r\n";
    const std::string WebUtil::_get = "GET";
    const std::string WebUtil::_post = "POST";
    const std::string WebUtil::_http = "HTTP";
    const std::string WebUtil::_connection = "Connection:";
    const std::string WebUtil::_close = "close";


    // закрыть соединение?
    bool
    WebUtil::_toClose(const std::string & request)
    {
        const size_t posConnection = request.find(_connection);
        if (posConnection == std::string::npos)
            return false;
        const size_t posClose = request.find(_close);
        if (posClose == std::string::npos)
            return false;
        return true;
    }


    // находим первую строку от sep до sep, которая содержит шаблон
    // возвращаем номер строки, или -1 если такой строки нет
    int
    WebUtil::_graspPattern(const std::string & request, const std::string & pattern, std::string & line)
    {
        const size_t pos = request.find(pattern);
        if (pos == std::string::npos)
            return -1;

        size_t beg = request.rfind(_sep, pos);
        if (beg == std::string::npos)
            beg = 0;
        else
            beg += _sep.length();

        size_t end = request.find(_sep, pos);
        if (end == std::string::npos)
            end = request.length();

        line = request.substr(beg, end);
        return 0;
    }


    // создать http-запрос
    std::string
    WebUtil::generateHTTPRequest(const bool ok, const bool close)
    {
        std::string request;
        if (ok)
            request += "HTTP/1.0 200 OK\r\nContent-Type: text/html\r\n";
        else
            request += "HTTP/1.0 404 Not Found\r\nContent-Type: text/html\r\n";

        if (close)
            request += "Connection: close\r\n";
        request += "\r\n";

        return request;
    }
}

