#if !defined(WEBUTIL_H)
#define WEBUTIL_H

#include <string>

namespace Pathfinder
{
    // тут мы разбираем http-запросы
    class WebUtil
    {
    private:
        // словарь
        static const std::string _sep; // "\r\n"
        static const std::string _get; // "GET"
        static const std::string _post; // "POST"
        static const std::string _http; // "HTTP"
        static const std::string _connection; // "Connection:"
        static const std::string _close; // "close"

    public:
        // конструктор
        WebUtil(){}
        // деструктор
        ~WebUtil(){}

    public:
        // находим GET строку
        static int graspGet(const std::string & request, std::string & line) { return _graspPattern(request, _get, line); }
        // находим POST строку
        static int graspPost(const std::string & request, std::string & line) { return _graspPattern(request, _post, line); }
        // находим Connection строку
        static int graspConnection(const std::string & request, std::string & line) { return _graspPattern(request, _connection, line); }
        // находим HTTP строку
        static int graspHTTP(const std::string & request, std::string & line) { return _graspPattern(request, _http, line); }
        // закрыть соединение?
        static bool toClose(const std::string & request) { return _toClose(request); }
        // создать http-запрос
        static std::string generateHTTPRequest(const bool ok, const bool close);

    private:
        // находим первую строку от sep до sep, которая содержит шаблон
        // возвращаем номер строки, или -1 если такой строки нет
        static int _graspPattern(const std::string & request, const std::string & pattern, std::string & line);
        // закрыть соединение?
        static bool _toClose(const std::string & request);
    };
}
#endif

