import logging

import geobase6

log = logging.getLogger(__name__)


class AbstractGeobaseClient:
    def region_id_by_location(self, lon, lat):
        raise NotImplementedError()

    def parents(self, rid):
        raise NotImplementedError()

    def region_by_id(self, rid):
        raise NotImplementedError()

    def calculate_distance(self, p1_lon, p1_lat, p2_lon, p2_lat):
        return geobase6.calculate_distance(p1_lat, p1_lon, p2_lat, p2_lon)


# TODO: https://a.yandex-team.ru/arc/trunk/arcadia/travel/rasp/library/python/common/utils/geobase.py
class LocalGeobaseClient(AbstractGeobaseClient):
    def __init__(self, path):
        self._lookup = geobase6.Lookup(path)

    def region_id_by_location(self, lon, lat):
        return self._lookup.get_region_id_by_location(lat, lon)

    def parents(self, rid):
        return self._lookup.get_parents_ids(rid)

    def region_by_id(self, rid):
        return self._lookup.get_region_by_id(rid)


class GeobaseClientStub(AbstractGeobaseClient):
    def __init__(self, data):
        self._lookup = data

    def region_id_by_location(self, lon, lat):
        return self._lookup.get('region_{}_{}'.format(lat, lon))

    def parents(self, rid):
        return self._lookup.get('parents_{}'.format(rid), [])

    def region_by_id(self, rid):
        return self._lookup.get('region_{}'.format(rid))
