import logging
from datetime import timedelta

from aiohttp import client

from travel.rasp.pathfinder_maps.maps_protos.common2.response_pb2 import Response
from travel.rasp.pathfinder_maps.protos.builders import build_maps_stress_result


log = logging.getLogger(__name__)


class MapsClient:
    def __init__(self, endpoint, tvm_provider, tvm_destination):
        self._endpoint = endpoint
        self._tvm_provider = tvm_provider
        self._tvm_destination = tvm_destination

    async def route(self, rll, pctx=None, dtm=None, atm=None):
        url = '{}/masstransit/v2/route'.format(self._endpoint)
        headers = {'Accept': 'application/x-protobuf'}

        params = [
            ('rll', '~'.join(point.as_string for point in rll)),
            ('results', '1'),
            ('origin', 'pathfinder-maps')
        ]
        if pctx:
            params.append(('pctx', pctx))
        if dtm:
            params.append(('dtm', int(dtm.timestamp())))
        if atm:
            params.append(('atm', int(atm.timestamp())))

        headers['X-Ya-Service-Ticket'] = self._tvm_provider.get_ticket(self._tvm_destination)
        async with client.ClientSession() as session:
            async with session.get(url, params=params, headers=headers) as response:
                log.debug('Maps request: %s', response.real_url)
                response.raise_for_status()
                content = await response.read()
                response = Response().FromString(content)

                return response


class MapsClientStressMock:
    async def route(self,  rll, pctx=None, dtm=None, atm=None):
        log.debug('rll %s, dtm: %s', rll, dtm)
        return build_maps_stress_result(rll, dtm, dtm + timedelta(minutes=10))
