from datetime import timedelta
from enum import Enum

import pytz


MSK_TZ = pytz.timezone('Europe/Moscow')
UTC_TZ = pytz.UTC


class TTYPE(Enum):
    train = 1
    aero = 2
    bus = 3
    suburban = 6

    @property
    def rasp_name(self):
        return 'plane' if self is TTYPE.aero else self.name


WAIT_TIMES = {
    TTYPE.aero: timedelta(hours=2),
    TTYPE.bus: timedelta(minutes=20),
    TTYPE.train: timedelta(minutes=20),
    TTYPE.suburban: timedelta(minutes=20)
}

POST_WAIT_TIMES = {
    TTYPE.aero: timedelta(minutes=30),
    TTYPE.bus: timedelta(minutes=5),
    TTYPE.train: timedelta(minutes=10),
    TTYPE.suburban: timedelta(minutes=5)
}
