from functools import reduce

from dataclasses import dataclass

from travel.rasp.pathfinder_maps.models.route import Route, json_to_route


@dataclass
class Variant:
    routes: list

    def __hash__(self):
        return reduce(lambda x, y: (x << 1) ^ hash(y), self.routes, 0)

    def __str__(self):
        return ' -> '.join(map(str, self.routes[::2]))


def json_to_variant(data) -> Variant:
    return Variant(list(map(json_to_route, data['segments'])))


def build_teleportation_route(prev_route: Route, next_route: Route) -> Route:
    return Route(
        'NULL',
        prev_route.arrival_datetime,
        prev_route.arrival_station_id,
        next_route.departure_datetime,
        next_route.departure_station_id
    )
