from functools import reduce

import travel.rasp.pathfinder_maps.maps_protos.common2.geo_object_pb2 as geo_object_pb2
import travel.rasp.pathfinder_maps.maps_protos.common2.response_pb2 as response_pb2
import travel.rasp.pathfinder_maps.maps_protos.masstransit.route_pb2 as route_pb2

from travel.rasp.pathfinder_maps.protos.utils import join_bounds
from travel.rasp.pathfinder_maps.utils import seconds_to_duration_text


def join_routes(route1, route2):
    route = geo_object_pb2.GeoObject()
    route_meta = route.metadata.add().Extensions[route_pb2.ROUTE_METADATA]
    r1_meta = route1.metadata[0].Extensions[route_pb2.ROUTE_METADATA]
    r2_meta = route2.metadata[0].Extensions[route_pb2.ROUTE_METADATA]

    route_meta.CopyFrom(r1_meta)

    route_meta.estimation.CopyFrom(r1_meta.estimation)
    if r2_meta.estimation.arrival_time.IsInitialized():
        route_meta.estimation.arrival_time.CopyFrom(r2_meta.estimation.arrival_time)

    route_meta.weight.time.value += r2_meta.weight.time.value
    route_meta.weight.time.text = seconds_to_duration_text(route_meta.weight.time.value)
    route_meta.weight.walking_distance.value += r2_meta.weight.walking_distance.value
    route_meta.weight.walking_distance.text = seconds_to_duration_text(route_meta.weight.walking_distance.value)
    route_meta.weight.transfers_count += r2_meta.weight.transfers_count

    route_meta.way_point.extend(r1_meta.way_point[:] + r2_meta.way_point[:])

    join_bounds([route1.bounded_by, route2.bounded_by], route.bounded_by)
    route.geo_object.extend(route1.geo_object[:] + route2.geo_object[:])

    return route


def join_protos(protos):
    response = response_pb2.Response()

    bounds = [proto.reply.bounded_by for proto in protos]
    geo_objects = [proto.reply.geo_object[0] for proto in protos]

    join_bounds(bounds, response.reply.bounded_by)
    response.reply.geo_object.extend([reduce(join_routes, geo_objects)])

    return response


def join_results(results):
    response = response_pb2.Response()

    bounds = [res.reply.bounded_by for res in results]
    join_bounds(bounds, response.reply.bounded_by)

    routes = []
    for res in results:
        routes.extend(res.reply.geo_object[:])

    response.reply.geo_object.extend(routes)
    return response
