import pickle
import six


class PickleRepository:
    def __init__(self):
        self._storage = {}

    def add(self, key, value):
        raise NotImplementedError()

    def get(self, key):
        return self._storage.get(key)

    def itervalues(self):
        return six.itervalues(self._storage)

    def load_from_file(self, path):
        with open(path, 'rb') as f:
            for k, v in pickle.load(f, encoding='latin1')['segments'].items():
                self.add(k, v)
