from marshmallow import fields, Schema


class PollingKeysList(fields.Field):
    def _deserialize(self, value, attr, data):
        polling_keys = [value for value in data.getall(attr, [])]
        return sorted(polling_keys)


class PollRequestSchema(Schema):
    polling_keys = PollingKeysList(load_from='polling_key', missing=[])
