from datetime import datetime, timezone

from marshmallow import fields, post_load, Schema

from travel.rasp.pathfinder_maps.utils import RoutePoint


class RouteRequestSchema(Schema):
    rll = fields.String(load_from='rll', missing='', required=True)
    dtm = fields.Integer(required=True)

    @post_load
    def rll_prepare(self, data):
        data['rll'] = [RoutePoint(*tuple(map(float, x.split(',')))) for x in data.get('rll').split('~')]
        data['dtm'] = datetime.fromtimestamp(data['dtm'], timezone.utc)
