import logging

from travel.library.python.dicts.country_repository import CountryRepository
from travel.library.python.dicts.district_repository import DistrictRepository
from travel.library.python.dicts.pathfinder_maps_nearest_settlement_repository import PathfinderMapsNearestSettlementRepository
from travel.library.python.dicts.region_repository import RegionRepository
from travel.library.python.dicts.settlement_repository import SettlementRepository
from travel.library.python.dicts.station_repository import StationRepository
from travel.library.python.dicts.timezone_repository import TimezoneRepository
from travel.rasp.pathfinder_maps.repos.limepaths_repository import LimepathsRepository
from travel.rasp.pathfinder_maps.repos.railways_repository import RailwaysRepository


log = logging.getLogger(__name__)


class ProtobufDataProvider:
    def __init__(self):
        self.country_repo = CountryRepository()
        self.district_repo = DistrictRepository()
        self.nearest_settlement_repo = PathfinderMapsNearestSettlementRepository()
        self.region_repo = RegionRepository()
        self.settlement_repo = SettlementRepository()
        self.station_repo = StationRepository()
        self.timezone_repo = TimezoneRepository()

    def load_from_dir(self, proto_dir):
        repos = [
            (self.country_repo, 'country/country.data'),
            (self.district_repo, 'district/district.data'),
            (self.nearest_settlement_repo, 'pathfinder_maps_nearest_settlement/pathfinder_maps_nearest_settlement.bin'),
            (self.region_repo, 'region/region.data'),
            (self.settlement_repo, 'settlement/settlement.data'),
            (self.station_repo, 'station/station.data'),
            (self.timezone_repo, 'timezone/timezone.data')
        ]

        for repo, filename in repos:
            repo.load_from_file(proto_dir / filename)


class PickleDataProvider:
    def __init__(self, work_db_discoverer):
        self.railway_geometry = RailwaysRepository()
        self.limepaths_geometry = LimepathsRepository()
        self._work_db_discoverer = work_db_discoverer

    def load_from_dir(self, proto_dir):
        work_db = self._work_db_discoverer.get_work_db()
        log.debug('work_db: {}'.format(work_db))
        if work_db is None:
            work_db = 'main0_rasp'
        repos = [
            (self.railway_geometry, 'geometry/geometry/{}/railways.pickle'.format(work_db)),
            (self.limepaths_geometry, 'geometry/geometry/{}/limepaths.pickle'.format(work_db))
        ]
        for repo, filename in repos:
            repo.load_from_file(proto_dir / filename)
