class GeobaseService:
    SETTLEMENT_TYPES = {6, 7}

    def __init__(self, client):
        self._client = client

    def get_settlement_by_location(self, point):
        settlements = list(self.iterate_settlements_by_location(point))
        if settlements:
            return settlements[0]

    def iterate_settlements_by_location(self, point):
        rid = self._client.region_id_by_location(point.lon, point.lat)
        for parent_id in self._client.parents(rid):
            parent_info = self._client.region_by_id(parent_id)
            if parent_info.get('type') in self.SETTLEMENT_TYPES:
                yield parent_id

    def calculate_distance(self, point1, point2):
        return self._client.calculate_distance(point1[0], point1[1], point2[0], point2[1])
