from asyncio import gather

from travel.rasp.pathfinder_maps.const import TTYPE
from travel.rasp.pathfinder_maps.services.joiners.base_joiner import BaseJoiner


class PathfinderJoiner(BaseJoiner):
    async def join(self, splitted_rll, settlements, dtm, request_context):
        request_context.pathfinder_first()
        request_context.set_pathfinder_settlements(settlements)

        query = {
            'from_type': settlements[0][0],
            'from_id': settlements[0][1],
            'to_type': settlements[1][0],
            'to_id': settlements[1][1],
            'date': dtm
        }
        searches = [self._morda_backend_service.search(query, [ttype]) for ttype in TTYPE]
        searches.append(self._morda_backend_service.search(query))
        variants = await gather(*searches)
        variants[-1] = [
            variant for variant in variants[-1]
            if len({route.thread_info[2] for route in variant.routes[::2]}) > 1
        ]

        variants = self._protobuf_builder.filter_variants(variants)

        departure_times = await self._get_departure_times(variants, splitted_rll, dtm, request_context)
        arrival_stations = await self._get_arrival_stations(variants, splitted_rll)
        result = await gather(*[
            self._build_variants(splitted_rll, ttype_variants, departure_times, arrival_stations, dtm, request_context)
            for ttype_variants in variants
        ])
        return [x for x in result if x is not None]
