import json

from travel.rasp.pathfinder_maps.cache import AioRedisCache
from travel.rasp.pathfinder_maps.models.route import Route


class PollingCache:
    def __init__(self, cache: AioRedisCache):
        self._cache = cache

    async def get_price(self, polling_key: str):
        raise NotImplementedError()

    async def get_from_cache_or_init(self, route: Route) -> dict:
        cache_data = await self.get_from_cache(route.polling_key)
        if cache_data is not None:
            return cache_data

        data = {
            'route': route.to_dict(),
            'price': None,
            'travel_link': None,
            'is_polling': False,
            'is_done': False
        }
        await self.set_cache(route.polling_key, data)
        return data

    async def get_from_cache(self, polling_key: str):
        data_from_cache = await self._cache.get_from_cache(polling_key)
        if data_from_cache is None:
            return None

        data = json.loads(data_from_cache)
        data['route'] = Route.from_dict(data['route'])
        return data

    async def set_cache(self, polling_key: str, data: dict):
        data = json.dumps(data, ensure_ascii=False)
        await self._cache.set_cache(polling_key, data)
