import logging

from travel.rasp.pathfinder_maps.clients.morda_backend_client import MordaBackendClient

log = logging.getLogger(__name__)


class WorkDBDiscoverer:
    def get_work_db(self):
        raise NotImplementedError()


class MordaBackendWorkDBDiscoverer(WorkDBDiscoverer):
    def __init__(self, morda_backend_client: MordaBackendClient):
        self.client = morda_backend_client

    def get_work_db(self):
        conf = self.client.get_maintenance_conf()
        if conf:
            return conf['work_db']

        log.error("Can't discover work_db. Request to morda_backend has failed!")
