import os
from pathlib import Path


class BaseSettings:
    PROTO_DIR = Path(os.getenv('PATHFINDER_MAPS_PROTO_DIR', '/app/data'))
    GEOBASE_PATH = os.getenv('GEOBASE_PATH', '/var/cache/geobase/geodata6.bin')

    HOSTS = os.getenv('PATHFINDER_MAPS_HOSTS', '127.0.0.1,[::1]').split(',')
    PORT = os.getenv('PATHFINDER_MAPS_PORT', '9000')

    LOG_PATH = '/var/log/app/'

    LOGGING_CONFIG = {
        'version': 1,
        'handlers': {
            'stream': {
                'class': 'logging.StreamHandler',
                'stream': 'ext://sys.stdout',
                'level': 'DEBUG',
                'formatter': 'context_formatter'
            },
            'file': {
                'class': 'logging.FileHandler',
                'level': 'DEBUG',
                'filename': os.path.join(LOG_PATH, 'pathfinder_maps.log'),
                'formatter': 'context_formatter'
            },
            'yt.rasp-pathfinder-maps-thread-warnings': {
                'class': 'logging.handlers.WatchedFileHandler',
                'level': 'INFO',
                'filename': os.path.join(LOG_PATH, 'yt', 'rasp-pathfinder-maps-thread-warnings.log'),
                'formatter': 'json_formatter'
            },
            'yt.rasp-pathfinder-maps-request-logger': {
                'class': 'logging.handlers.WatchedFileHandler',
                'level': 'INFO',
                'filename': os.path.join(LOG_PATH, 'yt', 'rasp-pathfinder-maps-request-logger.log'),
                'formatter': 'json_formatter'
            },
        },
        'loggers': {
            'travel.rasp.pathfinder_maps': {
                'handlers': ['stream', 'file'],
                'level': 'DEBUG',
                'propagate': False
            },
            'yt.rasp-pathfinder-maps-thread-warnings': {
                'handlers': ['yt.rasp-pathfinder-maps-thread-warnings'],
                'level': 'INFO',
                'propagate': False
            },
            'yt.rasp-pathfinder-maps-request-logger': {
                'handlers': ['yt.rasp-pathfinder-maps-request-logger'],
                'level': 'INFO',
                'propagate': False
            },
        },
        'formatters': {
            'context_formatter': {
                'class': 'travel.library.python.aioapp.logger.deploy_formatter.DeployJsonFormatter'
            },
            'json_formatter': {
                'class': 'pythonjsonlogger.jsonlogger.JsonFormatter',
                'json_ensure_ascii': False
            },
        }
    }

    MAPS_MASSTRANSIT_URL = None
    RASP_SEARCH_URL = None

    REDIS_SERVICE_NAME = None
    REDIS_PASSWORD_PATH = None
    REDIS_HOSTS = None

    MORDA_BACKEND_URL = None
    TRAIN_API_ENDPOINT = None
    TICKET_DAEMON_ENDPOINT = None

    TVM_SOURCE_ID = None
    TVM_MAPS_ID = None
    TVM_TOKEN = os.environ.get('TVM_TOKEN')  # tvm_api client

    TRAINS_URL_PREFIX = None

    TRAVEL_TIME_COEFFICIENT = float(os.environ.get('TRAVEL_TIME_COEFFICIENT', 2.))
