import os
from travel.rasp.pathfinder_maps.settings.base import BaseSettings


class Settings(BaseSettings):
    MAPS_MASSTRANSIT_URL = os.getenv('MAPS_MASSTRANSIT_URL', 'http://core-masstransit-router.maps.yandex.net')
    RASP_SEARCH_URL = "https://rasp.yandex.ru/search"
    MORDA_BACKEND_URL = os.getenv('MORDA_BACKEND_URL', 'https://morda-backend.rasp.yandex.net')
    TRAIN_API_ENDPOINT = os.getenv('TRAIN_API_ENDPOINT', 'https://production.train-api.rasp.internal.yandex.net')
    TICKET_DAEMON_ENDPOINT = os.getenv('TICKET_DAEMON_ENDPOINT', 'http://ticket-daemon-api.production.avia.yandex.net')
    TRAINS_URL_PREFIX = os.getenv('TRAINS_URL_PREFIX', 'https://travel.yandex.ru/trains')

    REDIS_SERVICE_NAME = 'raas__production__main'
    REDIS_PASSWORD_PATH = 'rasp-common-production'
    REDIS_HOSTS = [
        'man-ijwkvja853y6uqqd.db.yandex.net', 'myt-qg260012a7d18i2f.db.yandex.net',
        'sas-la2w8uogx2m680jd.db.yandex.net', 'vla-1dihadeybcs8s1ck.db.yandex.net'
    ]

    TVM_SOURCE_ID = 2016197
    TVM_MAPS_ID = 2012630
