from dataclasses import dataclass


@dataclass
class RoutePoint:
    lon: float
    lat: float

    @property
    def as_string(self):
        return '{},{}'.format(self.lon, self.lat)

    def get_copy(self):
        return RoutePoint(self.lon, self.lat)

    def __hash__(self):
        return hash((self.lon + 180) * 180 + (self.lat + 90))


def seconds_to_duration_text(seconds):
    days = int((seconds // (60 * 60 * 24)))
    hours = int((seconds // (60 * 60)) % 24)
    minutes = int((seconds // 60) % 60)

    result = []
    if days > 0:
        result.append('{} д'.format(days))
    if hours > 0:
        result.append('{} ч'.format(hours))
    if minutes > 0:
        result.append('{} мин'.format(minutes))

    return ' '.join(result)


def get_point_with_prefix(station):
    return f'c{station["settlement"]["id"]}' if 'settlement' in station else f's{station["id"]}'
