import logging

from aiohttp import web

from travel.rasp.pathfinder_maps.logs import get_request_context
from travel.rasp.pathfinder_maps.serialization.polling import PollRequestSchema
from travel.rasp.pathfinder_maps.serialization.requests import RouteRequestSchema
from travel.rasp.pathfinder_maps.services.path_joiner import PathJoiner
from travel.rasp.pathfinder_maps.services.polling_services.polling_service import PollingService

log = logging.getLogger(__name__)


class Handler:
    def __init__(self, path_joiner: PathJoiner, polling_service: PollingService):
        self._path_joiner = path_joiner
        self._polling_service = polling_service

    async def ping(self, request):
        return web.Response(body='Ok', status=200)

    async def route(self, request):
        route_request = RouteRequestSchema(strict=True).load(request.query).data
        with get_request_context(route_request) as request_context:
            routes = await self._path_joiner.join(route_request['rll'], route_request['dtm'], request_context)
            return web.Response(body=routes.SerializeToString(), status=200)

    async def poll(self, request):
        polling_request = PollRequestSchema(strict=True).load(request.query).data
        prices = await self._polling_service.poll(polling_request['polling_keys'])
        return web.Response(body=prices.SerializeToString(), status=200)
