PY3_LIBRARY(pathfinder-maps)

OWNER(
    g:rasp-back
    mikhalych
)

PEERDIR(
    contrib/python/aiohttp
    contrib/python/gunicorn
    contrib/python/aioredis/aioredis-1
    contrib/python/jaeger-client
    contrib/python/marshmallow/py2
    contrib/python/numpy
    contrib/python/opentracing-async-instrumentation
    contrib/python/python-json-logger
    contrib/python/pytz
    contrib/python/scipy

    geobase/python/static

    library/python/yenv
    library/python/deprecated/ticket_parser2

    travel/library/python/aioapp/logger
    travel/library/python/aioapp/middlewares
    travel/library/python/dicts
    travel/library/python/rasp_vault
    travel/library/python/tracing/gunicorn
    travel/library/python/tvm_ticket_provider

    travel/rasp/library/python/gunicorn
    travel/rasp/library/python/ticket_daemon_client/async_client
    travel/rasp/library/python/tracing
    travel/rasp/library/python/train_api_client/async_client

    travel/rasp/pathfinder_maps/maps_protos/common2
    travel/rasp/pathfinder_maps/maps_protos/masstransit
    travel/rasp/pathfinder_maps/maps_protos/pm_protos
)

PY_SRCS(
    clients/geobase_client.py
    clients/maps_client.py
    clients/morda_backend_client.py

    models/route.py
    models/variant.py

    protos/builders.py
    protos/joiners.py
    protos/utils.py

    repos/__init__.py
    repos/railways_repository.py
    repos/limepaths_repository.py

    settings/__init__.py
    settings/base.py
    settings/development.py
    settings/production.py
    settings/stress.py
    settings/testing.py

    serialization/polling.py
    serialization/proto_to_json.py
    serialization/requests.py

    services/joiners/base_joiner.py
    services/joiners/maps_joiner.py
    services/joiners/pathfinder_joiner.py

    services/polling_services/polling_answer.py
    services/polling_services/polling_cache.py
    services/polling_services/polling_service.py
    services/polling_services/ticket_daemon_service.py
    services/polling_services/train_api_service.py

    services/data_provider.py
    services/geobase_service.py
    services/morda_backend_service.py
    services/nearest_point_finder.py
    services/path_joiner.py
    services/protobuf_builder.py
    services/work_db_discoverer.py

    tvm/tvm_client.py
    tvm/tvm_provider.py

    app.py
    cache.py
    const.py
    logs.py
    utils.py
    views.py
)

END()

RECURSE(
    bin
    maps_protos
)

RECURSE_FOR_TESTS(
    tests
)
