import os

from opentracing_async_instrumentation.client_hooks import aiohttpclient

from travel.rasp.library.python.gunicorn import run_gunicorn
from travel.rasp.pathfinder_proxy.app import create_app
from travel.rasp.pathfinder_proxy.settings import Settings
from travel.rasp.library.python.tracing.sampling import build_jaeger_config
from travel.library.python.tracing.gunicorn import build_post_fork

if __name__ == '__main__':
    settings = Settings()
    post_fork = build_post_fork(
        build_jaeger_config('rasp.pathfinder-proxy'),
        patch_all=False, func=aiohttpclient.patcher.install_patches
    )
    options = {
        'bind': ('{}:{}'.format(host, settings.PORT) for host in settings.HOSTS),
        'worker': os.environ.get('GUNICORN_WORKERS', 1),
        'worker_class': 'aiohttp.worker.GunicornWebWorker',
        'timeout': os.environ.get('GUNICORN_TIMEOUT', 30),
        'post_fork': post_fork
    }
    app = create_app(settings)
    run_gunicorn(app, options)
