from dataclasses import dataclass
from typing import List

from travel.rasp.pathfinder_proxy.client_tariffs.tariff_info import TariffInfo


@dataclass
class TrainApiResult:
    querying: bool
    tariffs: List[TariffInfo]


@dataclass
class TrainTariffInfo(TariffInfo):
    has_dynamic_pricing: bool
    provider: str
    raw_train_name: str = None


def make_result(result):
    tariffs = []
    for segment in result['segments']:
        tariffs.append(TrainTariffInfo(
            segment['stationFrom']['id'],
            segment['stationTo']['id'],
            segment['tariffs'],
            segment['departure'][:-9],
            segment['arrival'][:-9],
            segment['thread'].get('number') if segment.get('thread') else None,
            segment['hasDynamicPricing'],
            segment['provider'],
            segment.get('rawTrainName'),
        ))

    return TrainApiResult(
        result['querying'],
        tariffs
    )


def make_empty_result(querying):
    return TrainApiResult(querying, [])
