from datetime import timedelta
from enum import IntEnum, Enum

import pytz

MSK_TZ = pytz.timezone('Europe/Moscow')
UTC_TZ = pytz.UTC


class TTransport(IntEnum):
    TRAIN = 1
    PLANE = 2
    BUS = 3
    SUBURBAN = 6

    @staticmethod
    def get_by_name(value):
        return TRANSPORT_BY_CODE.get(value)

    @staticmethod
    def get_by_code(value):
        return {x.value: x for x in TTransport}.get(value)

    @staticmethod
    def get_name(value):
        return CODE_BY_TRANSPORT.get(value)


CODE_BY_TRANSPORT = {
    TTransport.TRAIN: 'train',
    TTransport.PLANE: 'plane',
    TTransport.BUS: 'bus',
    TTransport.SUBURBAN: 'suburban',
}

TRANSPORT_BY_CODE = {
    'train': TTransport.TRAIN,
    'plane': TTransport.PLANE,
    'bus': TTransport.BUS,
    'suburban': TTransport.SUBURBAN,
}


class CacheType(Enum):
    SERP = 'serp'
    MORDA_BACKEND = 'morda-backend'
    TRAIN_API = 'train-api'
    TICKET_DAEMON_API = 'ticket-daemon-api'
    TRANSFERS_WITH_PRICES = 'transfers-with-prices'
    INTERLINE = 'interline'

    @staticmethod
    def get_expire_by_type(value):
        return EXPIRE_BY_TYPE.get(value)


EXPIRE_BY_TYPE = {
    CacheType.SERP: int(timedelta(days=1).total_seconds()),
    CacheType.MORDA_BACKEND: int(timedelta(hours=1).total_seconds()),
    CacheType.TRAIN_API: int(timedelta(minutes=30).total_seconds()),
    CacheType.TICKET_DAEMON_API: int(timedelta(minutes=30).total_seconds()),
    CacheType.TRANSFERS_WITH_PRICES: int(timedelta(minutes=30).total_seconds()),
    CacheType.INTERLINE: int(timedelta(minutes=30).total_seconds())
}


class Status(Enum):
    QUERYING = 'querying'
    DONE = 'done'
    ERROR = 'error'
