from travel.library.python.aioapp.utils import localize_dt
from travel.rasp.pathfinder_proxy.const import TTransport, UTC_TZ
from travel.rasp.pathfinder_proxy.services.base_service import BaseService
from travel.rasp.pathfinder_proxy.tariff_collectors.interline_collector import InterlineCollector


class InterlineService(BaseService):
    _COLLECTOR = InterlineCollector
    _TRANSPORT_TYPE = TTransport.PLANE

    def _merge_variants_with_tariffs(self, transfer_variants, tariffs, querying):
        tariffs_by_key = {tariff['key']: tariff['result'] for tariff in tariffs if tariff is not None}

        for variant in transfer_variants:
            segments = variant['segments']
            if any(segment['transport']['code'] != self._transport_code for segment in segments):
                continue
            key = tuple(
                (
                    int(segment['stationFrom']['id']),
                    int(segment['stationTo']['id']),
                    localize_dt(segment['departure'][:-9], UTC_TZ),
                    segment['thread']['number']
                )
                for segment in segments
            )

            tariff = tariffs_by_key.get(key)
            if tariff is not None:
                variant['tariffs'] = tariff

    @staticmethod
    def _merge_segment(segment, tariff):
        segment['tariffs'] = tariff
