import os

from ticket_parser2.api.v1 import BlackboxEnv


class BaseSettings:
    TRAINS_URL_PREFIX = None

    LOG_PATH = '/var/log/app/'

    LOGGING_CONFIG = {
        'version': 1,
        'handlers': {
            'stream': {
                'class': 'logging.StreamHandler',
                'stream': 'ext://sys.stdout',
                'level': 'DEBUG',
                'formatter': 'context_formatter',
            },
            'file': {
                'class': 'logging.FileHandler',
                'filename': os.path.join(LOG_PATH, 'proxy.log'),
                'level': 'DEBUG',
                'formatter': 'context_formatter',
            },
            'tariff_collector_file': {
                'class': 'logging.FileHandler',
                'filename': os.path.join(LOG_PATH, 'tariff_collector.log'),
                'level': 'DEBUG',
                'formatter': 'context_formatter',
            },
            'yt.pathfinder-proxy-search': {
                'class': 'logging.handlers.WatchedFileHandler',
                'filename': os.path.join(LOG_PATH, 'yt', 'pathfinder-proxy-search.log'),
                'formatter': 'json_formatter',
                'level': 'INFO'
            },
            'yt.pathfinder-proxy-tariffs': {
                'class': 'logging.handlers.WatchedFileHandler',
                'filename': os.path.join(LOG_PATH, 'yt', 'pathfinder-proxy-tariffs.log'),
                'formatter': 'json_formatter',
                'level': 'INFO'
            },
            'yt.pathfinder-proxy-result': {
                'class': 'logging.handlers.WatchedFileHandler',
                'filename': os.path.join(LOG_PATH, 'yt', 'pathfinder-proxy-result.log'),
                'formatter': 'json_formatter',
                'level': 'INFO'
            }
        },
        'loggers': {
            'travel.rasp.pathfinder_proxy': {
                'handlers': ['stream', 'file'],
                'level': 'DEBUG',
                'propagate': False
            },
            'tariff_collector': {
                'handlers': ['stream', 'tariff_collector_file'],
                'level': 'DEBUG',
                'propagate': False
            },
            'yt.pathfinder-proxy-search': {
                'handlers': ['yt.pathfinder-proxy-search'],
                'level': 'INFO',
                'propagate': False
            },
            'yt.pathfinder-proxy-tariffs': {
                'handlers': ['yt.pathfinder-proxy-tariffs'],
                'level': 'INFO',
                'propagate': False
            },
            'yt.pathfinder-proxy-result': {
                'handlers': ['yt.pathfinder-proxy-result'],
                'level': 'INFO',
                'propagate': False
            }
        },
        'formatters': {
            'context_formatter': {
                'class': 'travel.library.python.aioapp.logger.deploy_formatter.DeployJsonFormatter'
            },
            'json_formatter': {
                'format': '%(message)s',
                '()': 'pythonjsonlogger.jsonlogger.JsonFormatter',
                'json_ensure_ascii': False
            }
        }
    }

    HOSTS = os.getenv('PATHFINDER_PROXY_HOSTS', '127.0.0.1,[::1]').split(',')
    PORT = os.getenv('PATHFINDER_PROXY_PORT', '9000')

    REDIS_SERVICE_NAME = None
    REDIS_PASSWORD_PATH = None
    REDIS_HOSTS = None

    TRAIN_API_ENDPOINT = None
    MORDA_BACKEND_ENDPOINT = None
    TICKET_DAEMON_ENDPOINT = None

    FRONT_SUBURBAN_TARIFFS = os.getenv('FRONT_SUBURBAN_TARIFFS', False)

    TVM_SERVICE_ID = 2024809
    TVM_FAKE = False
    TVM_SECRET = os.getenv('TVM_SECRET')
    TVM_BLACKBOX_ENV = BlackboxEnv.Test
    TVM_DESTINATIONS = {'TVM_BANDIT': 2020186}

    BANDIT_API_ENDPOINT = 'travel-trains-bandit-testing.balancer.internal.yandex.net:9111'
    BANDIT_API_TIMEOUT = 2
