import os

from ticket_parser2.api.v1 import BlackboxEnv
from travel.rasp.pathfinder_proxy.settings.base import BaseSettings


class Settings(BaseSettings):
    TRAINS_URL_PREFIX = 'https://travel.yandex.ru/trains'

    REDIS_SERVICE_NAME = 'raas__production__main'
    REDIS_PASSWORD_PATH = 'rasp-common-production'
    REDIS_HOSTS = [
        'man-ijwkvja853y6uqqd.db.yandex.net', 'myt-qg260012a7d18i2f.db.yandex.net',
        'sas-la2w8uogx2m680jd.db.yandex.net', 'vla-1dihadeybcs8s1ck.db.yandex.net'
    ]
    TRAIN_API_ENDPOINT = os.getenv('TRAIN_API_ENDPOINT', 'https://production.train-api.rasp.internal.yandex.net')
    MORDA_BACKEND_ENDPOINT = os.getenv('MORDA_BACKEND_ENDPOINT', 'https://morda-backend.rasp.yandex.net')
    TICKET_DAEMON_ENDPOINT = os.getenv('TICKET_DAEMON_ENDPOINT', 'http://ticket-daemon-api.production.avia.yandex.net')

    TVM_SERVICE_ID = 2024811
    TVM_BLACKBOX_ENV = BlackboxEnv.Prod
    TVM_DESTINATIONS = {'TVM_BANDIT': 2020188}

    BANDIT_API_ENDPOINT = 'travel-trains-bandit-production.balancer.internal.yandex.net:9111'
