from travel.library.python.aioapp.utils import localize_dt
from travel.rasp.pathfinder_proxy.client_tariffs.ticket_daemon_result import make_empty_tariffs, make_tariffs
from travel.rasp.pathfinder_proxy.const import TTransport, UTC_TZ
from travel.rasp.pathfinder_proxy.tariff_collectors.base_tariff_collector import BaseTariffCollector
from travel.rasp.pathfinder_proxy.tariff_storages.ticket_daemon_storage import TicketDaemonStorage


class TicketDaemonCollector(BaseTariffCollector):
    _TRANSPORT_TYPE = TTransport.PLANE
    _CACHE_STORAGE = TicketDaemonStorage

    @staticmethod
    def _make_result(result, poll):
        return make_tariffs(result, poll)

    @staticmethod
    def _prepare_tariff(tariff):
        tariff.departure_dt = localize_dt(tariff.departure_dt, UTC_TZ)
        tariff.arrival_dt = localize_dt(tariff.arrival_dt, UTC_TZ)

        variants = list(tariff.tariff.values())
        if not variants:
            return None

        min_variant = variants[0]
        for variant in variants[1:]:
            if variant['tariff']['value'] < min_variant['tariff']['value']:
                min_variant = variant

        if min_variant['tariff']['currency'] == 'RUR':
            min_variant['tariff']['currency'] = 'RUB'

        return {
            'key': (tariff.departure_station_id, tariff.arrival_station_id, tariff.departure_dt),
            'result': {
                'electronicTicket': False,
                'classes': {
                    'economy': {
                        'partner': min_variant['partner'],
                        'price': min_variant['tariff'],
                        'orderUrl': min_variant['deep_link']
                    }
                }
            }
        }

    @staticmethod
    def _make_empty_result(querying):
        return make_empty_tariffs(querying)
