from marshmallow import fields, post_load, Schema

from travel.rasp.pathfinder_proxy.client_tariffs.tariff_info import TariffInfo


class TariffInfoSchema(Schema):
    departure_station_id = fields.Integer()
    arrival_station_id = fields.Integer()
    tariff = fields.Dict()
    departure_dt = fields.String()
    arrival_dt = fields.String()
    number = fields.String(allow_none=True)
    has_dynamic_pricing = fields.Boolean()

    @post_load
    def load_object(self, data):
        return TariffInfo(**data)


class BaseTariffStorage:
    _RESULT_SCHEMA = None
    _CACHE_TYPE = None

    def __init__(self, cache):
        self._cache = cache

    async def get(self, storage_key):
        result = await self._cache.get_from_cache(self._CACHE_TYPE, *storage_key)
        if result:
            result, error = self._RESULT_SCHEMA.loads(result)
            return result.tariffs, result.querying
        return [], False

    async def set(self, storage_key, result):
        result, error = self._RESULT_SCHEMA.dumps(result)
        await self._cache.set_cache(self._CACHE_TYPE, *storage_key, result)
