from marshmallow import fields, post_load, Schema

from travel.rasp.pathfinder_proxy.client_tariffs.ticket_daemon_result import TicketDaemonInterlineResult, VariantInfo
from travel.rasp.pathfinder_proxy.const import CacheType
from travel.rasp.pathfinder_proxy.tariff_storages.base_tariff_storage import BaseTariffStorage, TariffInfoSchema


class VariantInfoSchema(Schema):
    variants = fields.List(fields.Raw())
    segments = fields.Nested(TariffInfoSchema, many=True)

    @post_load
    def load_object(self, data):
        return VariantInfo(**data)


class TicketDaemonInterlineResultSchema(Schema):
    querying = fields.Boolean()
    tariffs = fields.Nested(VariantInfoSchema, many=True)

    @post_load
    def load_object(self, data):
        return TicketDaemonInterlineResult(**data)


class InterlineStorage(BaseTariffStorage):
    _RESULT_SCHEMA = TicketDaemonInterlineResultSchema()
    _CACHE_TYPE = CacheType.INTERLINE
