from marshmallow import fields, post_load, Schema

from travel.rasp.pathfinder_proxy.client_tariffs.ticket_daemon_result import TicketDaemonResult
from travel.rasp.pathfinder_proxy.const import CacheType
from travel.rasp.pathfinder_proxy.tariff_storages.base_tariff_storage import BaseTariffStorage, TariffInfoSchema


class TicketDaemonResultSchema(Schema):
    querying = fields.Boolean()
    tariffs = fields.Nested(TariffInfoSchema, many=True)

    @post_load
    def load_object(self, data):
        return TicketDaemonResult(**data)


class TicketDaemonStorage(BaseTariffStorage):
    _RESULT_SCHEMA = TicketDaemonResultSchema()
    _CACHE_TYPE = CacheType.TICKET_DAEMON_API
