from travel.library.python.tvm_ticket_provider import provider_fabric


class TvmFactory(object):
    def __init__(self, settings):
        self._tvm_provider = None
        self.service_id = settings.TVM_SERVICE_ID
        self.fake = settings.TVM_FAKE
        self.secret = settings.TVM_SECRET
        self.blackbox_env = settings.TVM_BLACKBOX_ENV
        self.destinations = settings.TVM_DESTINATIONS

    def get_provider(self):
        if self.service_id and not self._tvm_provider:
            self._tvm_provider = provider_fabric.create(
                source_id=self.service_id,
                destinations=[val for key, val in self.destinations.items()],
                fake=self.fake,
                secret=self.secret,
                blackbox_env=self.blackbox_env,
            )
        return self._tvm_provider
