PY3_LIBRARY(pathfinder-proxy)

OWNER(
    g:rasp-back
    monitorius
    lorekhov
)

PEERDIR(
    contrib/python/protobuf
    contrib/python/aiohttp
    contrib/python/gunicorn
    contrib/python/aioredis/aioredis-1
    contrib/python/grpcio-opentracing
    contrib/python/cached-property
    contrib/python/marshmallow/py2
    contrib/python/opentracing-async-instrumentation
    contrib/python/python-json-logger
    contrib/python/pytz
    contrib/python/redis
    library/python/yenv
    library/python/deprecated/ticket_parser2

    travel/library/python/tracing/gunicorn
    travel/library/python/aioapp/logger
    travel/library/python/aioapp/middlewares
    travel/library/python/aioapp/utils
    travel/rasp/library/python/gunicorn
    travel/rasp/library/python/httpclient/async_client
    travel/rasp/library/python/morda_backend_client/async_client
    travel/rasp/library/python/ticket_daemon_client/async_client
    travel/rasp/library/python/tracing
    travel/rasp/library/python/train_api_client/async_client
    travel/rasp/library/python/train_wizard_api_client/async_client
    travel/library/python/tvm_ticket_provider
    travel/library/python/rasp_vault
    travel/rasp/pathfinder_proxy/settings
    travel/rasp/train_bandit_api/proto
)


PY_SRCS(
    client_tariffs/tariff_info.py
    client_tariffs/ticket_daemon_result.py
    client_tariffs/train_api_result.py

    services/base_service.py
    services/interline_service.py
    services/morda_backend_service.py
    services/price_collector.py
    services/ticket_daemon_service.py
    services/train_api_service.py
    services/train_fee_service.py

    tariff_collectors/base_tariff_collector.py
    tariff_collectors/interline_collector.py
    tariff_collectors/ticket_daemon_collector.py
    tariff_collectors/train_api_collector.py

    tariff_storages/base_tariff_storage.py
    tariff_storages/interline_storage.py
    tariff_storages/ticket_daemon_storage.py
    tariff_storages/train_api_storage.py

    app.py
    cache.py
    const.py
    logs.py
    serialization.py
    tvm.py
    views.py
)


END()

RECURSE(
    bin
    settings
)

RECURSE_FOR_TESTS(
    tests
)
