#include <travel/rasp/rasp_data/dumper/lib/dumpers/rasp_data_dumper.h>

#include <library/cpp/getopt/last_getopt.h>
#include <library/cpp/logger/global/global.h>

using namespace NRasp::NDumper;

int main(int argc, const char* argv[]) {
    TString directoryPath;
    TString geobasePath;
    TString tankerAuthToken;
    TMySqlConfig config;

    {
        auto opts = NLastGetopt::TOpts::Default();

        opts.AddLongOption("host", "MySQL host").RequiredArgument("HOST").DefaultValue("localhost").StoreResult(&config.host);
        opts.AddLongOption("user", "MySQL user").RequiredArgument("USER").StoreResult(&config.user);
        opts.AddLongOption("password", "MySQL password").RequiredArgument("PASSWORD").StoreResult(&config.passport);
        opts.AddLongOption("name", "MySQL database name").RequiredArgument("NAME").DefaultValue("rasp").StoreResult(&config.db);
        opts.AddLongOption("geobasePath", "Path to geobase data").RequiredArgument("GEOBASE_PATH").StoreResult(&geobasePath).Required();
        opts.AddLongOption("tankerAuthToken", "OAuthToken to Tanker").RequiredArgument("TANKER_AUTH_TOKEN").StoreResult(&tankerAuthToken).Required();
        opts.AddLongOption("out", "Output folder").RequiredArgument("DIRECTORY").StoreResult(&directoryPath).Required();
        opts.SetFreeArgsNum(0);

        NLastGetopt::TOptsParseResult optsResult{&opts, argc, argv};
    }
    TRaspDataDumper dumper{directoryPath, geobasePath, tankerAuthToken, config};
    try {
        dumper.Dump();
    } catch (yexception& e) {
        Cerr << "Dump error: " << e.what() << Endl;
        return 1;
    } catch (...) {
        ERROR_LOG << "Unexpected error" << Endl;
    }
}
