#include "aviaalliance_dumper.h"

using namespace NRasp::NData;

namespace NRasp {
    namespace NDumper {
        TAviaAllianceSelectQuery::TAviaAllianceSelectQuery()
            : TSelectQuery("www_aviaalliance", false)
            , IdField(AddField("id"))
            , LogoSvgField(AddField("logo_svg"))
            , EnabledField(AddField("enabled"))
            , TitleField(AddField("title"))
            , TitleRuField(AddField("title_ru"))
            , TitleEnField(AddField("title_en"))
            , TitleTrField(AddField("title_tr"))
            , TitleUkField(AddField("title_uk"))
            , DescriptionField(AddField("description"))
            , DescriptionRuField(AddField("description_ru"))
            , DescriptionEnField(AddField("description_en"))
            , DescriptionTrField(AddField("description_tr"))
            , DescriptionUkField(AddField("description_uk"))
        {
        }

        TAviaAllianceDumper::TAviaAllianceDumper(NRasp::NDumper::IFetcher& fetcher,
                                                 IObjectWriter<NData::TAviaAlliance>& writer)
            : Query({})
            , Fetcher_(fetcher)
            , Writer_(writer)
        {
        }

        TSet<i32> TAviaAllianceDumper::Dump() {
            INFO_LOG << "Run the avia alliance dumper" << Endl;
            Fetcher_.InitQuery(Query.Str());

            TSet<i32> aviaallianceIds;
            TVector<TString> row(Query.Size());
            while (Fetcher_.GetNext(&row)) {
                const i32 id = ParseId(row[Query.IdField]);

                TAviaAlliance record;
                record.SetId(id);

                record.SetLogoSvg(row[Query.LogoSvgField]);
                record.SetEnabled(ParseBool(row[Query.EnabledField]));
                record.SetTitleDefault(row[Query.TitleField]);
                record.MutableTitle()->SetRu(row[Query.TitleRuField]);
                record.MutableTitle()->SetEn(row[Query.TitleEnField]);
                record.MutableTitle()->SetTr(row[Query.TitleTrField]);
                record.MutableTitle()->SetUk(row[Query.TitleUkField]);

                record.SetDescriptionDefault(row[Query.DescriptionField]);
                record.MutableDescription()->SetRu(row[Query.DescriptionRuField]);
                record.MutableDescription()->SetEn(row[Query.DescriptionEnField]);
                record.MutableDescription()->SetTr(row[Query.DescriptionTrField]);
                record.MutableDescription()->SetUk(row[Query.DescriptionUkField]);

                aviaallianceIds.insert(id);
                Writer_.Write(record);
            };

            if (aviaallianceIds.empty()) {
                ythrow yexception() << "Avia alliance dumper has no records.";
            }
            INFO_LOG << "The avia alliance dumper has dumped. Total count of carriers is " << aviaallianceIds.size() << Endl;

            return aviaallianceIds;
        }
    }
}
