#pragma once

#include <library/cpp/logger/global/global.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/mysql_fetcher.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/mysql_field_parsers.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/select_query.h>
#include <travel/rasp/rasp_data/dumper/lib/object_writer/object_writer.h>
#include <travel/proto/dicts/rasp/aviaalliance.pb.h>

#include <util/generic/set.h>

namespace NRasp {
    namespace NDumper {
        class TAviaAllianceSelectQuery: public TSelectQuery {
        public:
            TAviaAllianceSelectQuery();

        public:
            const i32 IdField;

            const i32 LogoSvgField;
            const i32 EnabledField;

            const i32 TitleField;
            const i32 TitleRuField;
            const i32 TitleEnField;
            const i32 TitleTrField;
            const i32 TitleUkField;

            const i32 DescriptionField;
            const i32 DescriptionRuField;
            const i32 DescriptionEnField;
            const i32 DescriptionTrField;
            const i32 DescriptionUkField;
        };

        class TAviaAllianceDumper {
        public:
            TAviaAllianceDumper(NRasp::NDumper::IFetcher& fetcher,
                                IObjectWriter<NData::TAviaAlliance>& writer);

            TSet<i32> Dump();

        public:
            const TAviaAllianceSelectQuery Query;

        private:
            NRasp::NDumper::IFetcher& Fetcher_;
            IObjectWriter<NData::TAviaAlliance>& Writer_;
        };
    }
}
