#include "aviaalliance_dumper.h"

#include <travel/rasp/rasp_data/dumper/lib/fetcher/fake_fetcher.h>
#include <travel/rasp/rasp_data/dumper/lib/object_writer/fake_object_writer.h>
#include <travel/rasp/rasp_data/dumper/lib/tester/json.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NRasp::NData;
using namespace NRasp::NDumper;

class TAviaAllianceDumperTest: public TTestBase {
private:
    UNIT_TEST_SUITE(TAviaAllianceDumperTest);
    UNIT_TEST(TestEmpty);
    UNIT_TEST(TestOneRecord);
    UNIT_TEST_SUITE_END();

private:
    TFakeFetcher Fetcher_;
    TFakeObjectWriter<TAviaAlliance> ObjectWriter_;
    THolder<TAviaAllianceDumper> Dumper_;

public:
    void SetUp() override {
        Fetcher_ = {};
        ObjectWriter_ = TFakeObjectWriter<TAviaAlliance>();
        Dumper_ = MakeHolder<TAviaAllianceDumper>(Fetcher_, ObjectWriter_);
    }

    TVector<TString> CreateRow() {
        return {
            ToString(1001),        // id
            "logo.svg",            // logo_svg
            ToString(false),       // enabled
            "title_default",       // title
            "title_ru",            // title_ru
            "title_en",            // title_en
            "title_tr",            // title_tr
            "title_uk",            // title_uk
            "description_default", // description
            "description_ru",      // description_ru
            "description_en",      // description_en
            "description_tr",      // description_tr
            "description_uk",      // description_uk
        };
    }

    TAviaAlliance CreateModel() {
        TAviaAlliance record;
        record.SetId(1001);
        record.SetLogoSvg("logo.svg");
        record.SetTitleDefault("title_default");
        record.MutableTitle()->SetRu("title_ru");
        record.MutableTitle()->SetEn("title_en");
        record.MutableTitle()->SetTr("title_tr");
        record.MutableTitle()->SetUk("title_uk");

        record.SetDescriptionDefault("description_default");
        record.MutableDescription()->SetRu("description_ru");
        record.MutableDescription()->SetEn("description_en");
        record.MutableDescription()->SetTr("description_tr");
        record.MutableDescription()->SetUk("description_uk");
        return record;
    }

    void TestEmpty();

    void TestOneRecord();
};

UNIT_TEST_SUITE_REGISTRATION(TAviaAllianceDumperTest);

void TAviaAllianceDumperTest::TestEmpty() {
    Fetcher_.Add({});
    UNIT_ASSERT_EXCEPTION(Dumper_->Dump(), yexception);
}

void TAviaAllianceDumperTest::TestOneRecord() {
    Fetcher_.Add({CreateRow()});

    UNIT_ASSERT_EQUAL(Dumper_->Dump(), TSet<i32>{1001});
    UNIT_ASSERT_STRINGS_EQUAL(ToJson(ObjectWriter_.GetResult()), ToJson(TVector<TAviaAlliance>{CreateModel()}));
}
