#include "carrier_dumper.h"

using namespace NRasp::NData;

namespace NRasp {
    namespace NDumper {
        TCarrierSelectQuery::TCarrierSelectQuery()
            : TSelectQuery("www_company", false)
            , IdField(AddField("id"))
            , AddressField(AddField("address"))
            , HomeStationIdField(AddField("home_station_id"))
            , IataField(AddField("iata"))
            , IcaoField(AddField("icao"))
            , TitleField(AddField("title"))
            , TitleEnField(AddField("title_en"))
            , UrlField(AddField("url"))
            , ContactInfoField(AddField("contact_info"))
            , DescriptionField(AddField("description"))
            , LogoField(AddField("logo"))
            , CountryIdField(AddField("country_id"))
            , TransportTypeField(AddField("t_type_id"))
            , IsHiddenField(AddField("hidden"))
            , IsStrangeField(AddField("strange"))
            , EmailField(AddField("email"))
            , SirenaIdField(AddField("sirena_id"))
            , PhoneField(AddField("phone"))
            , PhoneBookingField(AddField("phone_booking"))
            , MetaTitleField(AddField("meta_title"))
            , MetaDescriptionField(AddField("meta_description"))
            , SupplierCodeField(AddField("supplier_code"))
            , TitleRuField(AddField("title_ru"))
            , TitleUkField(AddField("title_uk"))
            , TitleTrField(AddField("title_tr"))
            , ShortTitleField(AddField("short_title"))
            , ShortTitleRuField(AddField("short_title_ru"))
            , ShortTitleEnField(AddField("short_title_en"))
            , ShortTitleUkField(AddField("short_title_uk"))
            , ShortTitleTrField(AddField("short_title_tr"))
            , IsFreightField(AddField("is_freight"))
            , IconField(AddField("icon"))
            , LogoMonoField(AddField("logo_mono"))
            , LogoBgColorField(AddField("logo_bgcolor"))
            , PriorityField(AddField("priority"))
            , IcaoRuField(AddField("icao_ru"))
            , SvgLogoField(AddField("svg_logo"))
            , AllianceIdField(AddField("alliance_id"))
            , BonusNameField(AddField("bonus_name"))
            , BonusNameRuField(AddField("bonus_name_ru"))
            , BonusNameEnField(AddField("bonus_name_en"))
            , BonusNameTrField(AddField("bonus_name_tr"))
            , BonusNameUkField(AddField("bonus_name_uk"))
            , Svg2PngLogoField(AddField("svg2png_logo"))
            , RegistrationPhoneField(AddField("registration_phone"))
            , RegistrationPhoneRuField(AddField("registration_phone_ru"))
            , RegistrationPhoneEnField(AddField("registration_phone_en"))
            , RegistrationPhoneTrField(AddField("registration_phone_tr"))
            , RegistrationPhoneUkField(AddField("registration_phone_uk"))
            , RegistrationUrlField(AddField("registration_url"))
            , RegistrationUrlRuField(AddField("registration_url_ru"))
            , RegistrationUrlEnField(AddField("registration_url_en"))
            , RegistrationUrlTrField(AddField("registration_url_tr"))
            , RegistrationUrlUkField(AddField("registration_url_uk"))
            , TisCodeField(AddField("tis_code"))
            , ExpressCodeField(AddField("express_code"))
            , YandexAviaCodeField(AddField("yandex_avia_code"))
        {
        }

        TCarrierDumper::TCarrierDumper(
            NRasp::NDumper::IFetcher& fetcher,
            IObjectWriter<NData::TCarrier>& writer)
            : Query({})
            , Fetcher_(fetcher)
            , Writer_(writer)
        {
        }

        TSet<i32>
        TCarrierDumper::Dump(const TSet<i32>& stationIds, const TSet<ui32>& countryIds) {
            INFO_LOG << "Run the carriers dumper" << Endl;
            Fetcher_.InitQuery(Query.Str());

            TSet<i32> carrierIds;
            TVector<TString> row(Query.Size());
            while (Fetcher_.GetNext(&row)) {
                const i32 id = ParseId(row[Query.IdField]);

                const auto homeStationId = ParseId(row[Query.HomeStationIdField]);
                if (homeStationId != 0 && !stationIds.contains(homeStationId)) {
                    WARNING_LOG << "SKIP TCarrier: Can not find a station by id: [" << homeStationId << "] for the carrier with id: [" << id << "]" << Endl;
                    continue;
                }

                TCarrier record;
                record.SetId(id);
                record.SetAddress(row[Query.AddressField]);
                record.SetHomeStationId(homeStationId);
                record.SetIata(row[Query.IataField]);
                record.SetIcao(row[Query.IcaoField]);
                record.SetTitle(row[Query.TitleField]);
                record.SetTitleEn(row[Query.TitleEnField]);
                record.SetUrl(row[Query.UrlField]);
                record.SetContactInfo(row[Query.ContactInfoField]);
                record.SetDescription(row[Query.DescriptionField]);
                record.SetLogo(row[Query.LogoField]);
                record.SetIsHidden(ParseBool(row[Query.IsHiddenField]));
                record.SetIsStrange(ParseBool(row[Query.IsStrangeField]));
                record.SetEmail(row[Query.EmailField]);
                record.SetSirenaId(row[Query.SirenaIdField]);
                record.SetPhone(row[Query.PhoneField]);
                record.SetPhoneBooking(row[Query.PhoneBookingField]);
                record.SetMetaTitle(row[Query.MetaTitleField]);
                record.SetMetaDescription(row[Query.MetaDescriptionField]);
                record.SetSupplierCode(row[Query.SupplierCodeField]);
                record.SetTitleRu(row[Query.TitleRuField]);
                record.SetTitleUk(row[Query.TitleUkField]);
                record.SetTitleTr(row[Query.TitleTrField]);
                record.SetShortTitle(row[Query.ShortTitleField]);
                record.SetShortTitleRu(row[Query.ShortTitleRuField]);
                record.SetShortTitleEn(row[Query.ShortTitleEnField]);
                record.SetShortTitleUk(row[Query.ShortTitleUkField]);
                record.SetShortTitleTr(row[Query.ShortTitleTrField]);
                record.SetIsFreight(ParseBool(row[Query.IsFreightField]));
                record.SetIcon(row[Query.IconField]);
                record.SetLogoMono(row[Query.LogoMonoField]);
                record.SetLogoBgColor(row[Query.LogoBgColorField]);
                record.SetPriority(ParseI32(row[Query.PriorityField]));
                record.SetIcaoRu(row[Query.IcaoRuField]);
                record.SetSvgLogo(row[Query.SvgLogoField]);
                record.SetAllianceId(ParseId(row[Query.AllianceIdField]));
                record.SetBonusName(row[Query.BonusNameField]);
                record.SetBonusNameRu(row[Query.BonusNameRuField]);
                record.SetBonusNameEn(row[Query.BonusNameEnField]);
                record.SetBonusNameTr(row[Query.BonusNameTrField]);
                record.SetBonusNameUk(row[Query.BonusNameUkField]);
                record.SetSvg2PngLogo(row[Query.Svg2PngLogoField]);
                record.SetRegistrationPhone(row[Query.RegistrationPhoneField]);
                record.SetRegistrationPhoneRu(row[Query.RegistrationPhoneRuField]);
                record.SetRegistrationPhoneEn(row[Query.RegistrationPhoneEnField]);
                record.SetRegistrationPhoneTr(row[Query.RegistrationPhoneTrField]);
                record.SetRegistrationPhoneUk(row[Query.RegistrationPhoneUkField]);
                record.SetRegistrationUrl(row[Query.RegistrationUrlField]);
                record.SetRegistrationUrlRu(row[Query.RegistrationUrlRuField]);
                record.SetRegistrationUrlEn(row[Query.RegistrationUrlEnField]);
                record.SetRegistrationUrlTr(row[Query.RegistrationUrlTrField]);
                record.SetRegistrationUrlUk(row[Query.RegistrationUrlUkField]);
                record.SetTisCode(row[Query.TisCodeField]);
                record.SetExpressCode(row[Query.ExpressCodeField]);
                record.SetYandexAviaCode(row[Query.YandexAviaCodeField]);

                {
                    const auto transportTypeId = ParseId(row[Query.TransportTypeField]);
                    if (!TTransport_EType_IsValid(transportTypeId)) {
                        WARNING_LOG << "SKIP TCarrier: Can not find transportTypeId with id [" << transportTypeId << "] for the carrier with id: [" << id << "]" << Endl;
                        continue;
                    }
                    record.SetTransportType(
                        static_cast<TTransport::EType>(transportTypeId));
                }

                {
                    const auto countryId = ParseId(row[Query.CountryIdField]);
                    if (countryId != 0 && !countryIds.contains(countryId)) {
                        WARNING_LOG << "SKIP TCarrier: Can not find a country by id: [" << countryId << "] for the carrier with id: [" << id << "]" << Endl;
                        continue;
                    }
                    record.SetCountryId(countryId);
                }

                carrierIds.insert(id);
                Writer_.Write(record);
            };

            if (carrierIds.empty()) {
                ythrow yexception() << "Carrier dumper has no records.";
            }
            INFO_LOG << "The carrier dumper has dumped. Total count of carriers is " << carrierIds.size() << Endl;

            return carrierIds;
        }
    }
}
