#pragma once

#include <travel/rasp/rasp_data/dumper/lib/fetcher/mysql_field_parsers.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/select_query.h>
#include <travel/rasp/rasp_data/dumper/lib/timezone_provider/timezone_provider.h>
#include <travel/proto/dicts/rasp/carrier.pb.h>
#include <travel/proto/dicts/rasp/transport.pb.h>

#include <util/generic/set.h>
#include <util/generic/hash.h>

#include <regex>

namespace NRasp {
    namespace NDumper {
        class TCarrierSelectQuery: public TSelectQuery {
        public:
            TCarrierSelectQuery();

        public:
            const i32 IdField;
            const i32 AddressField;
            const i32 HomeStationIdField;
            const i32 IataField;
            const i32 IcaoField;
            const i32 TitleField;
            const i32 TitleEnField;
            const i32 UrlField;
            const i32 ContactInfoField;
            const i32 DescriptionField;
            const i32 LogoField;
            const i32 CountryIdField;
            const i32 TransportTypeField;
            const i32 IsHiddenField;
            const i32 IsStrangeField;
            const i32 EmailField;
            const i32 SirenaIdField;
            const i32 PhoneField;
            const i32 PhoneBookingField;
            const i32 MetaTitleField;
            const i32 MetaDescriptionField;
            const i32 SupplierCodeField;
            const i32 TitleRuField;
            const i32 TitleUkField;
            const i32 TitleTrField;
            const i32 ShortTitleField;
            const i32 ShortTitleRuField;
            const i32 ShortTitleEnField;
            const i32 ShortTitleUkField;
            const i32 ShortTitleTrField;
            const i32 IsFreightField;
            const i32 IconField;
            const i32 LogoMonoField;
            const i32 LogoBgColorField;
            const i32 PriorityField;
            const i32 IcaoRuField;
            const i32 SvgLogoField;
            const i32 AllianceIdField;
            const i32 BonusNameField;
            const i32 BonusNameRuField;
            const i32 BonusNameEnField;
            const i32 BonusNameTrField;
            const i32 BonusNameUkField;
            const i32 Svg2PngLogoField;
            const i32 RegistrationPhoneField;
            const i32 RegistrationPhoneRuField;
            const i32 RegistrationPhoneEnField;
            const i32 RegistrationPhoneTrField;
            const i32 RegistrationPhoneUkField;
            const i32 RegistrationUrlField;
            const i32 RegistrationUrlRuField;
            const i32 RegistrationUrlEnField;
            const i32 RegistrationUrlTrField;
            const i32 RegistrationUrlUkField;
            const i32 TisCodeField;
            const i32 ExpressCodeField;
            const i32 YandexAviaCodeField;
        };

        class TCarrierDumper {
        public:
            TCarrierDumper(
                NRasp::NDumper::IFetcher& fetcher,
                IObjectWriter<NData::TCarrier>& writer);
            TSet<i32> Dump(const TSet<i32>& stationIds, const TSet<ui32>& countryIds);

        public:
            const TCarrierSelectQuery Query;

        private:
            NRasp::NDumper::IFetcher& Fetcher_;
            IObjectWriter<NData::TCarrier>& Writer_;
        };
    }
}
