#pragma once

#include <travel/rasp/rasp_data/dumper/lib/fetcher/mysql_fetcher.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/mysql_field_parsers.h>
#include <travel/rasp/rasp_data/dumper/lib/fetcher/select_query.h>
#include <travel/rasp/rasp_data/dumper/lib/linguistic_provider/linguistic_provider.h>
#include <travel/rasp/rasp_data/dumper/lib/object_writer/object_writer.h>
#include <travel/proto/dicts/rasp/country.pb.h>

#include <library/cpp/logger/global/global.h>

#include <util/generic/map.h>
#include <util/generic/set.h>

namespace NRasp {
    namespace NDumper {
        class TCountrySelectQuery: public TSelectQuery {
        public:
            TCountrySelectQuery();

        public:
            const i32 IdField;
            const i32 GeoIdField;
            const i32 CodeField;
            const i32 TitleField;
            const i32 Code3Field;
            const i32 KladrIdField;
            const i32 DomainZoneField;
            const i32 CurrencyIdField;
            const i32 LanguageField;
            const i32 ModifiedAtField;

            const i32 TitleRuField;
            const i32 TitleRuGenitiveField;
            const i32 TitleRuLocativeField;
            const i32 TitleRuLocativePrepositionField;
            const i32 TitleEnField;
            const i32 TitleUkField;
            const i32 TitleUkAccusativeField;
            const i32 TitleTrField;
        };

        class TCountryDumper {
        public:
            TCountryDumper(NRasp::NDumper::IFetcher& fetcher,
                           IObjectWriter<NData::TCountry>& writer,
                           const ILinguisticProvider& linguisticProvider);
            TSet<ui32> Dump();

        public:
            const TCountrySelectQuery Query;

        private:
            NRasp::NDumper::IFetcher& Fetcher_;
            IObjectWriter<NData::TCountry>& Writer_;
            const ILinguisticProvider& LinguisticProvider_;
        };
    }
}
