#include "country_dumper.h"

#include <travel/rasp/rasp_data/dumper/lib/fetcher/fake_fetcher.h>
#include <travel/rasp/rasp_data/dumper/lib/tester/fake_linguistic_provider.h>
#include <travel/rasp/rasp_data/dumper/lib/tester/json.h>
#include <travel/rasp/rasp_data/dumper/lib/object_writer/fake_object_writer.h>

#include <library/cpp/testing/unittest/registar.h>
#include <util/string/cast.h>

using namespace NRasp::NData;
using namespace NRasp::NDumper;

class TCountryDumperTest: public TTestBase {
private:
    UNIT_TEST_SUITE(TCountryDumperTest);
    UNIT_TEST(TestEmpty);
    UNIT_TEST(TestOneRecord);
    UNIT_TEST_SUITE_END();

private:
    TFakeFetcher Fetcher_;
    TFakeObjectWriter<TCountry> ObjectWriter_;
    THolder<TCountryDumper> Dumper_;
    TFakeLinguisticProvider LinguisticProvider_;

    ui32 Id;
    i32 GeoId;
    TString Code;
    TString Title;
    TString Code3;
    TString KladrId;
    TString DomainZone;
    ui32 CurrencyId;
    TString Language;
    TString ModifiedAt;

    TString TitleRu;
    TString TitleRuGenitive;
    TString TitleRuPrepositional;
    TString TitleRuLocativePreposition;
    TString TitleEn;
    TString TitleUk;
    TString TitleUkAccusative;
    TString TitleTr;

public:
    void SetUp() override {
        Fetcher_ = {};
        ObjectWriter_ = TFakeObjectWriter<TCountry>();
        LinguisticProvider_ = {};

        Dumper_ = MakeHolder<TCountryDumper>(Fetcher_, ObjectWriter_, LinguisticProvider_);
        Id = 187;
        GeoId = 8187;
        Code = "UA";
        Title = "Украина old title";

        Code3 = "UKR";
        KladrId = "кладр";
        DomainZone = "ua";
        CurrencyId = 1;
        Language = "uk";
        ModifiedAt = ToString(1591866043);

        TitleRu = "Украина";
        TitleRuGenitive = "Украины";
        TitleRuPrepositional = "Украине";
        TitleRuLocativePreposition = "в";
        TitleEn = "Ukraine";
        TitleUk = "";
        TitleUkAccusative = "Україну";
        TitleTr = "Ukrayna";
    }

    TVector<TString> CreateRow() {
        return {
            ToString(Id),               // id
            ToString(GeoId),            // _geo_id
            Code,                       // code
            Title,                      // title
            Code3,                      // code3
            KladrId,                    // _kladr_id
            DomainZone,                 // domain_zone
            ToString(CurrencyId),       // currency_id
            Language,                   // language
            ModifiedAt,                 // modified_at
            TitleRu,                    // title_ru
            TitleRuGenitive,            // title_ru_genitive
            TitleRuPrepositional,       // title_ru_locative
            TitleRuLocativePreposition, // title_ru_preposition_v_vo_na
            TitleEn,                    // title_en
            TitleUk,                    // title_uk
            TitleUkAccusative,          // title_uk_accusative
            TitleTr                     // title_tr
        };
    }
    TCountry CreateModel() {
        TCountry model;

        model.SetId(Id);
        model.SetGeoId(GeoId);
        model.SetCode(Code);
        model.SetTitleDefault(Title);

        model.SetCode3(Code3);
        model.SetKladrId(KladrId);
        model.SetDomainZone(DomainZone);
        model.SetCurrencyId(CurrencyId);
        model.SetLanguage(Language);
        model.MutableModifiedAt()->set_seconds(ParseI32(ModifiedAt));

        model.MutableTitle()->MutableRu()->SetNominative(TitleRu);
        model.MutableTitle()->MutableRu()->SetPrepositional(TitleRuPrepositional);
        model.MutableTitle()->MutableRu()->SetLocativePreposition(TitleRuLocativePreposition);
        model.MutableTitle()->MutableRu()->SetGenitive(TitleRuGenitive);

        model.MutableTitle()->MutableEn()->SetNominative(TitleEn);

        model.MutableTitle()->MutableTr()->SetNominative(TitleTr);

        model.MutableTitle()->MutableUk()->SetNominative(TitleUk);
        model.MutableTitle()->MutableUk()->SetAccusative(TitleUkAccusative);

        return model;
    }
    void TestEmpty();
    void TestOneRecord();
};

UNIT_TEST_SUITE_REGISTRATION(TCountryDumperTest);

void TCountryDumperTest::TestEmpty() {
    Fetcher_.Add({});

    UNIT_ASSERT_EXCEPTION(Dumper_->Dump(), yexception);
}

void TCountryDumperTest::TestOneRecord() {
    Fetcher_.Add({CreateRow()});

    UNIT_ASSERT_EQUAL(Dumper_->Dump(), TSet<ui32>{Id});
    UNIT_ASSERT_STRINGS_EQUAL(ToJson(ObjectWriter_.GetResult()), ToJson(TVector<TCountry>{CreateModel()}));
}
